/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.calendar.service.StdDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

public class StdEnumDateElement<V extends Enum<V>, T extends ChronoEntity<T>>
extends StdDateElement<V, T>
implements NumericalElement<V>,
TextElement<V> {
    private static final long serialVersionUID = -2452569351302286113L;
    private final transient Class<V> type;
    private final transient String defaultCalendarType;
    private final transient ChronoOperator<T> decrementor;
    private final transient ChronoOperator<T> incrementor;

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c) {
        super(string, clazz, c, StdEnumDateElement.isWeekdayElement(c));
        this.type = clazz2;
        this.defaultCalendarType = StdEnumDateElement.extractCalendarType(clazz);
        this.decrementor = null;
        this.incrementor = null;
    }

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c, String string2) {
        super(string, clazz, c, StdEnumDateElement.isWeekdayElement(c));
        this.type = clazz2;
        this.defaultCalendarType = string2;
        this.decrementor = null;
        this.incrementor = null;
    }

    public StdEnumDateElement(String string, Class<T> clazz, Class<V> clazz2, char c, ChronoOperator<T> chronoOperator, ChronoOperator<T> chronoOperator2) {
        super(string, clazz, c, false);
        this.type = clazz2;
        this.defaultCalendarType = StdEnumDateElement.extractCalendarType(clazz);
        this.decrementor = chronoOperator;
        this.incrementor = chronoOperator2;
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public V getDefaultMinimum() {
        return (V)((Enum[])this.type.getEnumConstants())[0];
    }

    @Override
    public V getDefaultMaximum() {
        Enum[] enumArray = (Enum[])this.type.getEnumConstants();
        return (V)enumArray[enumArray.length - 1];
    }

    @Override
    public int numerical(V v) {
        return ((Enum)v).ordinal() + 1;
    }

    @Override
    public ChronoOperator<T> decremented() {
        if (this.decrementor != null) {
            return this.decrementor;
        }
        return super.decremented();
    }

    @Override
    public ChronoOperator<T> incremented() {
        if (this.incrementor != null) {
            return this.incrementor;
        }
        return super.incremented();
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        Enum enum_ = (Enum)chronoDisplay.get(this);
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        appendable.append(this.accessor(attributeQuery, outputContext, this.isLeapMonth(enum_)).print(enum_));
    }

    @Override
    public V parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n = parsePosition.getIndex();
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        V v = this.accessor(attributeQuery, outputContext, false).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        if (v == null && this.isMonthElement()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n);
            v = this.accessor(attributeQuery, outputContext, true).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }
        if (v == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
            parsePosition.setErrorIndex(-1);
            parsePosition.setIndex(n);
            outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
            v = this.accessor(attributeQuery, outputContext, false).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            if (v == null && this.isMonthElement()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n);
                v = this.accessor(attributeQuery, outputContext, true).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            }
        }
        return v;
    }

    protected boolean isLeapMonth(V v) {
        return false;
    }

    protected boolean isEraElement() {
        return this.getSymbol() == 'G';
    }

    protected boolean isMonthElement() {
        return this.getSymbol() == 'M';
    }

    protected boolean isWeekdayElement() {
        return StdEnumDateElement.isWeekdayElement(this.getSymbol());
    }

    private static boolean isWeekdayElement(char c) {
        return c == 'E';
    }

    private static String extractCalendarType(Class<?> clazz) {
        CalendarType calendarType = clazz.getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }

    private TextAccessor accessor(AttributeQuery attributeQuery, OutputContext outputContext, boolean bl) {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        if (this.isMonthElement()) {
            CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, this.defaultCalendarType), locale);
            if (bl) {
                return calendarText.getLeapMonths(textWidth, outputContext);
            }
            return calendarText.getStdMonths(textWidth, outputContext);
        }
        if (this.isWeekdayElement()) {
            CalendarText calendarText = CalendarText.getIsoInstance(locale);
            return calendarText.getWeekdays(textWidth, outputContext);
        }
        if (this.isEraElement()) {
            CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, this.defaultCalendarType), locale);
            return calendarText.getEras(textWidth);
        }
        return CalendarText.getInstance(this.defaultCalendarType, locale).getTextForms(this.name(), this.type, new String[0]);
    }
}

