/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

public final class MathUtils {
    private MathUtils() {
    }

    public static int safeCast(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Out of range: " + l);
        }
        return (int)l;
    }

    public static int safeAdd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        long l = (long)n + (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n);
            stringBuilder.append(',');
            stringBuilder.append(n2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l;
    }

    public static long safeAdd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        if (l2 > 0L ? l > Long.MAX_VALUE - l2 : l < Long.MIN_VALUE - l2) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l);
            stringBuilder.append(',');
            stringBuilder.append(l2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l + l2;
    }

    public static int safeSubtract(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        long l = (long)n - (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n);
            stringBuilder.append(',');
            stringBuilder.append(n2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l;
    }

    public static long safeSubtract(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        if (l2 > 0L ? l < Long.MIN_VALUE + l2 : l > Long.MAX_VALUE + l2) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l);
            stringBuilder.append(',');
            stringBuilder.append(l2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l - l2;
    }

    public static int safeMultiply(int n, int n2) {
        if (n2 == 1) {
            return n;
        }
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Integer overflow: (");
            stringBuilder.append(n);
            stringBuilder.append(',');
            stringBuilder.append(n2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return (int)l;
    }

    public static long safeMultiply(long l, long l2) {
        if (l2 == 1L) {
            return l;
        }
        if (l2 > 0L ? l > Long.MAX_VALUE / l2 || l < Long.MIN_VALUE / l2 : (l2 < -1L ? l > Long.MIN_VALUE / l2 || l < Long.MAX_VALUE / l2 : l2 == -1L && l == Long.MIN_VALUE)) {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("Long overflow: (");
            stringBuilder.append(l);
            stringBuilder.append(',');
            stringBuilder.append(l2);
            stringBuilder.append(')');
            throw new ArithmeticException(stringBuilder.toString());
        }
        return l * l2;
    }

    public static int safeNegate(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new ArithmeticException("Not negatable: " + n);
        }
        return -n;
    }

    public static long safeNegate(long l) {
        if (l == Long.MIN_VALUE) {
            throw new ArithmeticException("Not negatable: " + l);
        }
        return -l;
    }

    public static int floorDivide(int n, int n2) {
        if (n >= 0) {
            return n / n2;
        }
        return (n + 1) / n2 - 1;
    }

    public static long floorDivide(long l, int n) {
        if (l >= 0L) {
            return l / (long)n;
        }
        return (l + 1L) / (long)n - 1L;
    }

    public static int floorModulo(int n, int n2) {
        return n - n2 * MathUtils.floorDivide(n, n2);
    }

    public static int floorModulo(long l, int n) {
        long l2 = l - (long)n * MathUtils.floorDivide(l, n);
        return (int)l2;
    }
}

