/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearRule;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.YearDefinition;

public final class HistoricDate
implements Comparable<HistoricDate> {
    private final HistoricEra era;
    private final int yearOfEra;
    private final int month;
    private final int dom;

    HistoricDate(HistoricEra historicEra, int n, int n2, int n3) {
        this.era = historicEra;
        this.yearOfEra = n;
        this.month = n2;
        this.dom = n3;
    }

    public static HistoricDate of(HistoricEra historicEra, int n, int n2, int n3) {
        return HistoricDate.of(historicEra, n, n2, n3, YearDefinition.DUAL_DATING, NewYearStrategy.DEFAULT);
    }

    public static HistoricDate of(HistoricEra historicEra, int n, int n2, int n3, YearDefinition yearDefinition, NewYearStrategy newYearStrategy) {
        if (historicEra == null) {
            throw new NullPointerException("Missing historic era.");
        }
        if (n3 < 1 || n3 > 31 || n2 < 1 || n2 > 12 || Math.abs(historicEra.annoDomini(n)) > 999999999) {
            throw new IllegalArgumentException("Out of range: " + HistoricDate.toString(historicEra, n, n2, n3));
        }
        if (historicEra == HistoricEra.BYZANTINE) {
            if (n < 0 || n == 0 && n2 < 9) {
                throw new IllegalArgumentException("Before creation of the world: " + HistoricDate.toString(historicEra, n, n2, n3));
            }
        } else if (n < 1) {
            throw new IllegalArgumentException("Year of era must be positive: " + HistoricDate.toString(historicEra, n, n2, n3));
        }
        if (!yearDefinition.equals((Object)YearDefinition.DUAL_DATING)) {
            NewYearRule newYearRule = newYearStrategy.rule(historicEra, n);
            n = newYearRule.standardYear(yearDefinition == YearDefinition.AFTER_NEW_YEAR, newYearStrategy, historicEra, n, n2, n3);
        }
        return new HistoricDate(historicEra, n, n2, n3);
    }

    public HistoricEra getEra() {
        return this.era;
    }

    public int getYearOfEra() {
        return this.yearOfEra;
    }

    public int getYearOfEra(NewYearStrategy newYearStrategy) {
        return newYearStrategy.displayedYear(this);
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    @Override
    public int compareTo(HistoricDate historicDate) {
        int n;
        int n2 = this.era.annoDomini(this.yearOfEra);
        if (n2 < (n = historicDate.era.annoDomini(historicDate.yearOfEra))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        int n3 = this.getMonth() - historicDate.getMonth();
        if (n3 == 0) {
            n3 = this.getDayOfMonth() - historicDate.getDayOfMonth();
        }
        return n3 < 0 ? -1 : (n3 > 0 ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistoricDate) {
            HistoricDate historicDate = (HistoricDate)object;
            return this.era == historicDate.era && this.yearOfEra == historicDate.yearOfEra && this.month == historicDate.month && this.dom == historicDate.dom;
        }
        return false;
    }

    public int hashCode() {
        int n = this.yearOfEra * 1000 + this.month * 32 + this.dom;
        return this.era == HistoricEra.AD ? n : -n;
    }

    public String toString() {
        return HistoricDate.toString(this.era, this.yearOfEra, this.month, this.dom);
    }

    private static String toString(HistoricEra historicEra, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(historicEra);
        stringBuilder.append('-');
        String string = String.valueOf(n);
        for (int i = 4 - string.length(); i > 0; --i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }
}

