/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;

final class LookupProcessor<V extends Enum<V>>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final Map<V, String> resources;
    private final int protectedLength;
    private final boolean caseInsensitive;
    private final Locale locale;

    LookupProcessor(ChronoElement<V> chronoElement, Map<V, String> map) {
        EnumMap<String, String> enumMap = new EnumMap<String, String>(chronoElement.getType());
        enumMap.putAll(map);
        this.element = chronoElement;
        this.resources = Collections.unmodifiableMap(enumMap);
        this.protectedLength = 0;
        this.caseInsensitive = true;
        this.locale = Locale.getDefault();
    }

    private LookupProcessor(ChronoElement<V> chronoElement, Map<V, String> map, int n, boolean bl, Locale locale) {
        this.element = chronoElement;
        this.resources = map;
        this.protectedLength = n;
        this.caseInsensitive = bl;
        this.locale = locale;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            int n = charSequence.length();
            this.print(chronoDisplay, appendable);
            if (set != null) {
                set.add(new ElementPosition(this.element, n, charSequence.length()));
            }
        } else {
            this.print(chronoDisplay, appendable);
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        int n;
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        int n4 = n = bl ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n > 0) {
            n3 -= n;
        }
        if (n2 >= n3) {
            parseLog.setError(n2, "Missing chars for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        boolean bl2 = bl ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.getDefault());
        int n5 = n3 - n2;
        for (Enum enum_ : (Enum[])this.element.getType().getEnumConstants()) {
            CharSequence charSequence2;
            String string = this.getString(enum_);
            if (bl2) {
                String string2;
                String string3 = string.toUpperCase(locale);
                int n6 = string.length();
                if (n6 > n5 || !string3.equals(string2 = charSequence.subSequence(n2, n2 + n6).toString().toUpperCase(locale))) continue;
                parsedValues.put(this.element, enum_);
                parseLog.setPosition(n2 + n6);
                return;
            }
            int n7 = string.length();
            if (n7 > n5 || !string.equals((charSequence2 = charSequence.subSequence(n2, n2 + n7)).toString())) continue;
            parsedValues.put(this.element, enum_);
            parseLog.setPosition(n2 + n7);
            return;
        }
        parseLog.setError(n2, "Enum value could not be parsed.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LookupProcessor) {
            LookupProcessor lookupProcessor = (LookupProcessor)object;
            return this.element.equals(lookupProcessor.element) && this.resources.equals(lookupProcessor.resources);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.resources.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", resources=");
        stringBuilder.append(this.resources);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new LookupProcessor<V>(chronoElement, this.resources);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<V> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new LookupProcessor<V>(this.element, this.resources, attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0), attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), attributeQuery.get(Attributes.LANGUAGE, Locale.getDefault()));
    }

    private void print(ChronoDisplay chronoDisplay, Appendable appendable) throws IOException {
        Enum enum_ = (Enum)chronoDisplay.get(this.element);
        appendable.append(this.getString(enum_));
    }

    private String getString(V v) {
        String string = this.resources.get(v);
        if (string == null) {
            string = ((Enum)v).toString();
        }
        return string;
    }
}

