/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.TZID;

class ParsedValues
extends ChronoEntity<ParsedValues> {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INT_PHI = -1640531527;
    private static final Set<ChronoElement<?>> INDEXED_ELEMENTS;
    private Object[] keys;
    private Object[] values;
    private Map<ChronoElement<?>, Object> map;
    private int[] ints;
    private int len;
    private int mask;
    private int threshold;
    private int count;
    private boolean duplicateKeysAllowed = false;
    private int position = -1;

    ParsedValues(int n, boolean bl) {
        if (bl) {
            this.len = Integer.MIN_VALUE;
            this.mask = Integer.MIN_VALUE;
            this.threshold = Integer.MIN_VALUE;
            this.count = Integer.MIN_VALUE;
            this.keys = null;
            this.values = null;
            this.ints = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.ints[i] = Integer.MIN_VALUE;
            }
        } else {
            this.len = ParsedValues.arraySize(n);
            this.mask = this.len - 1;
            this.threshold = ParsedValues.maxFill(this.len);
            this.keys = new Object[this.len];
            this.values = null;
            this.ints = new int[this.len];
            this.count = 0;
        }
        this.map = null;
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                return this.ints[0] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                return this.ints[1] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainDate.DAY_OF_MONTH) {
                return this.ints[2] != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                return this.len != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                return this.mask != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                return this.threshold != Integer.MIN_VALUE;
            }
            if (chronoElement == PlainTime.NANO_OF_SECOND) {
                return this.count != Integer.MIN_VALUE;
            }
            Map<ChronoElement<?>, Object> map = this.map;
            return map != null && map.containsKey(chronoElement);
        }
        int n = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n];
        if (object == null) {
            return false;
        }
        if (chronoElement.equals(object)) {
            return true;
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            return false;
        } while (!chronoElement.equals(object));
        return true;
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        int n;
        Object object;
        Class<V> clazz = chronoElement.getType();
        if (clazz == Integer.class) {
            int n2 = this.getInt0(chronoElement);
            if (n2 == Integer.MIN_VALUE) {
                throw new ChronoException("No value found for: " + chronoElement.name());
            }
            return clazz.cast(n2);
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            Map<ChronoElement<?>, Object> map = this.map;
            if (map != null && map.containsKey(chronoElement)) {
                return chronoElement.getType().cast(map.get(chronoElement));
            }
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        if (this.values == null || (object = objectArray[n = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) == null) {
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        if (chronoElement.equals(object)) {
            return clazz.cast(this.values[n]);
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            throw new ChronoException("No value found for: " + chronoElement.name());
        } while (!chronoElement.equals(object));
        return clazz.cast(this.values[n]);
    }

    @Override
    public int getInt(ChronoElement<Integer> chronoElement) {
        return this.getInt0(chronoElement);
    }

    @Override
    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return true;
    }

    @Override
    public <V> ParsedValues with(ChronoElement<V> chronoElement, V v) {
        this.put(chronoElement, v);
        return this;
    }

    @Override
    public ParsedValues with(ChronoElement<Integer> chronoElement, int n) {
        this.put(chronoElement, n);
        return this;
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return chronoElement.getDefaultMinimum();
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return chronoElement.getDefaultMaximum();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ParsedValues) {
            ParsedValues parsedValues = (ParsedValues)object;
            Set<ChronoElement<?>> set = this.getRegisteredElements();
            Set<ChronoElement<?>> set2 = parsedValues.getRegisteredElements();
            if (set.size() != set2.size()) {
                return false;
            }
            for (ChronoElement<?> chronoElement : set) {
                if (set2.contains(chronoElement) && this.get(chronoElement).equals(parsedValues.get(chronoElement))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.keys == null) {
            return Arrays.hashCode(this.ints) + 3 * this.len + 7 * this.mask + 11 * this.threshold + 31 * this.count;
        }
        return Arrays.hashCode(this.keys);
    }

    public String toString() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('{');
        for (ChronoElement<?> chronoElement : this.getRegisteredElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(this.get(chronoElement));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Set<ChronoElement<?>> getRegisteredElements() {
        if (this.keys == null) {
            HashSet<ChronoElement<Object>> hashSet = new HashSet<ChronoElement<Object>>();
            if (this.ints[0] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.YEAR);
            }
            if (this.ints[1] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.MONTH_AS_NUMBER);
            }
            if (this.ints[2] != Integer.MIN_VALUE) {
                hashSet.add(PlainDate.DAY_OF_MONTH);
            }
            if (this.len != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.DIGITAL_HOUR_OF_DAY);
            }
            if (this.mask != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.MINUTE_OF_HOUR);
            }
            if (this.threshold != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.SECOND_OF_MINUTE);
            }
            if (this.count != Integer.MIN_VALUE) {
                hashSet.add(PlainTime.NANO_OF_SECOND);
            }
            if (this.map != null) {
                hashSet.addAll(this.map.keySet());
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return new KeySet();
    }

    @Override
    protected Chronology<ParsedValues> getChronology() {
        throw new UnsupportedOperationException("Parsed values do not have any chronology.");
    }

    @Override
    public boolean hasTimezone() {
        return this.contains(TimezoneElement.TIMEZONE_ID) || this.contains(TimezoneElement.TIMEZONE_OFFSET);
    }

    @Override
    public TZID getTimezone() {
        TZID tZID = null;
        if (this.contains(TimezoneElement.TIMEZONE_ID)) {
            tZID = this.get(TimezoneElement.TIMEZONE_ID);
        } else if (this.contains(TimezoneElement.TIMEZONE_OFFSET)) {
            tZID = this.get(TimezoneElement.TIMEZONE_OFFSET);
        }
        if (tZID instanceof TZID) {
            return (TZID)TZID.class.cast(tZID);
        }
        return super.getTimezone();
    }

    void setPosition(int n) {
        this.position = n;
    }

    int getPosition() {
        return this.position;
    }

    void setNoAmbivalentCheck() {
        this.duplicateKeysAllowed = true;
    }

    int size() {
        if (this.keys == null) {
            int n;
            int n2 = n = this.len == Integer.MIN_VALUE ? 0 : 1;
            if (this.mask != Integer.MIN_VALUE) {
                ++n;
            }
            if (this.threshold != Integer.MIN_VALUE) {
                ++n;
            }
            if (this.count != Integer.MIN_VALUE) {
                ++n;
            }
            for (int i = 0; i < 3; ++i) {
                if (this.ints[i] == Integer.MIN_VALUE) continue;
                ++n;
            }
            if (this.map != null) {
                n += this.map.size();
            }
            return n;
        }
        return this.count;
    }

    static boolean isIndexed(ChronoElement<?> chronoElement) {
        return INDEXED_ELEMENTS.contains(chronoElement);
    }

    void putAll(ParsedValues parsedValues) {
        if (this.keys == null) {
            int n = parsedValues.len;
            if (n != Integer.MIN_VALUE) {
                if (this.len == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.len == n) {
                    this.len = n;
                } else {
                    throw new AmbivalentValueException(PlainTime.DIGITAL_HOUR_OF_DAY);
                }
            }
            if ((n = parsedValues.mask) != Integer.MIN_VALUE) {
                if (this.mask == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.mask == n) {
                    this.mask = n;
                } else {
                    throw new AmbivalentValueException(PlainTime.MINUTE_OF_HOUR);
                }
            }
            if ((n = parsedValues.threshold) != Integer.MIN_VALUE) {
                if (this.threshold == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.threshold == n) {
                    this.threshold = n;
                } else {
                    throw new AmbivalentValueException(PlainTime.SECOND_OF_MINUTE);
                }
            }
            if ((n = parsedValues.count) != Integer.MIN_VALUE) {
                if (this.count == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.count == n) {
                    this.count = n;
                } else {
                    throw new AmbivalentValueException(PlainTime.NANO_OF_SECOND);
                }
            }
            for (int i = 0; i < 3; ++i) {
                n = parsedValues.ints[i];
                if (n == Integer.MIN_VALUE) continue;
                if (this.ints[i] == Integer.MIN_VALUE || this.duplicateKeysAllowed || this.ints[i] == n) {
                    this.ints[i] = n;
                    continue;
                }
                throw new AmbivalentValueException(ParsedValues.getIndexedElement(i));
            }
            Map<ChronoElement<?>, Object> map = parsedValues.map;
            if (map != null) {
                for (ChronoElement<?> chronoElement : map.keySet()) {
                    this.put(chronoElement, map.get(chronoElement));
                }
            }
            return;
        }
        Object[] objectArray = parsedValues.keys;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            ChronoElement chronoElement = (ChronoElement)ChronoElement.class.cast(object);
            if (chronoElement.getType() == Integer.class) {
                this.put(chronoElement, parsedValues.ints[i]);
                continue;
            }
            this.put(chronoElement, parsedValues.values[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void put(ChronoElement<?> chronoElement, int n) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                if (!this.duplicateKeysAllowed && this.ints[0] != Integer.MIN_VALUE && this.ints[0] != n) throw new AmbivalentValueException(chronoElement);
                this.ints[0] = n;
                return;
            } else if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                if (!this.duplicateKeysAllowed && this.ints[1] != Integer.MIN_VALUE && this.ints[1] != n) throw new AmbivalentValueException(chronoElement);
                this.ints[1] = n;
                return;
            } else if (chronoElement == PlainDate.DAY_OF_MONTH) {
                if (!this.duplicateKeysAllowed && this.ints[2] != Integer.MIN_VALUE && this.ints[2] != n) throw new AmbivalentValueException(chronoElement);
                this.ints[2] = n;
                return;
            } else if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                if (!this.duplicateKeysAllowed && this.len != Integer.MIN_VALUE && this.len != n) throw new AmbivalentValueException(chronoElement);
                this.len = n;
                return;
            } else if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                if (!this.duplicateKeysAllowed && this.mask != Integer.MIN_VALUE && this.mask != n) throw new AmbivalentValueException(chronoElement);
                this.mask = n;
                return;
            } else if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                if (!this.duplicateKeysAllowed && this.threshold != Integer.MIN_VALUE && this.threshold != n) throw new AmbivalentValueException(chronoElement);
                this.threshold = n;
                return;
            } else if (chronoElement == PlainTime.NANO_OF_SECOND) {
                if (!this.duplicateKeysAllowed && this.count != Integer.MIN_VALUE && this.count != n) throw new AmbivalentValueException(chronoElement);
                this.count = n;
                return;
            } else {
                Map<ChronoElement<?>, Object> map = this.map;
                if (map == null) {
                    map = new HashMap();
                    this.map = map;
                }
                Integer n2 = n;
                if (!this.duplicateKeysAllowed && map.containsKey(chronoElement) && !((Object)n2).equals(map.get(chronoElement))) throw new AmbivalentValueException(chronoElement);
                map.put(chronoElement, n2);
                return;
            }
        }
        int n3 = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n3];
        if (object != null) {
            if (object.equals(chronoElement)) {
                if (!this.duplicateKeysAllowed && this.ints[n3] != n) throw new AmbivalentValueException(chronoElement);
                this.ints[n3] = n;
                return;
            }
            while ((object = objectArray[n3 = n3 + 1 & this.mask]) != null) {
                if (!object.equals(chronoElement)) continue;
                if (!this.duplicateKeysAllowed && this.ints[n3] != n) throw new AmbivalentValueException(chronoElement);
                this.ints[n3] = n;
                return;
            }
        }
        objectArray[n3] = chronoElement;
        this.ints[n3] = n;
        if (this.count++ < this.threshold) return;
        this.rehash(ParsedValues.arraySize(this.count));
    }

    void put(ChronoElement<?> chronoElement, Object object) {
        int n;
        Object object2;
        if (object == null) {
            this.remove(chronoElement);
            return;
        }
        if (chronoElement.getType() == Integer.class) {
            this.put(chronoElement, (Integer)Integer.class.cast(object));
            return;
        }
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            Map<ChronoElement<?>, Object> map = this.map;
            if (map == null) {
                map = new HashMap();
                this.map = map;
            }
            if (this.duplicateKeysAllowed || !map.containsKey(chronoElement) || object.equals(map.get(chronoElement))) {
                map.put(chronoElement, object);
                return;
            }
            throw new AmbivalentValueException(chronoElement);
        }
        if (this.values == null) {
            this.values = new Object[this.len];
        }
        if ((object2 = objectArray[n = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) != null) {
            if (object2.equals(chronoElement)) {
                if (this.duplicateKeysAllowed || object.equals(this.values[n])) {
                    this.values[n] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
            while ((object2 = objectArray[n = n + 1 & this.mask]) != null) {
                if (!object2.equals(chronoElement)) continue;
                if (this.duplicateKeysAllowed || object.equals(this.values[n])) {
                    this.values[n] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
        }
        objectArray[n] = chronoElement;
        this.values[n] = object;
        if (this.count++ >= this.threshold) {
            this.rehash(ParsedValues.arraySize(this.count));
        }
    }

    void reset() {
        if (this.keys == null) {
            this.len = Integer.MIN_VALUE;
            this.mask = Integer.MIN_VALUE;
            this.threshold = Integer.MIN_VALUE;
            this.count = Integer.MIN_VALUE;
            for (int i = 0; i < 3; ++i) {
                this.ints[i] = Integer.MIN_VALUE;
            }
            this.map = null;
        } else {
            this.keys = new Object[this.keys.length];
        }
        this.count = 0;
    }

    private int getInt0(ChronoElement<?> chronoElement) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (chronoElement == PlainDate.YEAR) {
                return this.ints[0];
            }
            if (chronoElement == PlainDate.MONTH_AS_NUMBER) {
                return this.ints[1];
            }
            if (chronoElement == PlainDate.DAY_OF_MONTH) {
                return this.ints[2];
            }
            if (chronoElement == PlainTime.DIGITAL_HOUR_OF_DAY) {
                return this.len;
            }
            if (chronoElement == PlainTime.MINUTE_OF_HOUR) {
                return this.mask;
            }
            if (chronoElement == PlainTime.SECOND_OF_MINUTE) {
                return this.threshold;
            }
            if (chronoElement == PlainTime.NANO_OF_SECOND) {
                return this.count;
            }
            Map<ChronoElement<?>, Object> map = this.map;
            if (map != null && map.containsKey(chronoElement)) {
                return (Integer)Integer.class.cast(map.get(chronoElement));
            }
            return Integer.MIN_VALUE;
        }
        int n = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n];
        if (object == null) {
            return Integer.MIN_VALUE;
        }
        if (chronoElement.equals(object)) {
            return this.ints[n];
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            return Integer.MIN_VALUE;
        } while (!chronoElement.equals(object));
        return this.ints[n];
    }

    private void remove(Object object) {
        Object[] objectArray = this.keys;
        if (objectArray == null) {
            if (object == PlainDate.YEAR) {
                this.ints[0] = Integer.MIN_VALUE;
            } else if (object == PlainDate.MONTH_AS_NUMBER) {
                this.ints[1] = Integer.MIN_VALUE;
            } else if (object == PlainDate.DAY_OF_MONTH) {
                this.ints[2] = Integer.MIN_VALUE;
            } else if (object == PlainTime.DIGITAL_HOUR_OF_DAY) {
                this.len = Integer.MIN_VALUE;
            } else if (object == PlainTime.MINUTE_OF_HOUR) {
                this.mask = Integer.MIN_VALUE;
            } else if (object == PlainTime.SECOND_OF_MINUTE) {
                this.threshold = Integer.MIN_VALUE;
            } else if (object == PlainTime.NANO_OF_SECOND) {
                this.count = Integer.MIN_VALUE;
            } else {
                Map<ChronoElement<?>, Object> map = this.map;
                if (map != null) {
                    map.remove(object);
                }
            }
            return;
        }
        int n = ParsedValues.mix(object.hashCode()) & this.mask;
        Object object2 = objectArray[n];
        if (object2 == null) {
            return;
        }
        if (object.equals(object2)) {
            this.removeEntry(n);
            return;
        }
        do {
            if ((object2 = objectArray[n = n + 1 & this.mask]) != null) continue;
            return;
        } while (!object.equals(object2));
        this.removeEntry(n);
    }

    private void removeEntry(int n) {
        --this.count;
        Object[] objectArray = this.keys;
        while (true) {
            Object object;
            int n2 = n;
            n = n2 + 1 & this.mask;
            while (true) {
                if ((object = objectArray[n]) == null) {
                    objectArray[n2] = null;
                    return;
                }
                int n3 = ParsedValues.mix(object.hashCode()) & this.mask;
                if (n2 <= n ? n2 >= n3 || n3 > n : n2 >= n3 && n3 > n) break;
                n = n + 1 & this.mask;
            }
            objectArray[n2] = object;
            if (this.values != null) {
                this.values[n2] = this.values[n];
            }
            this.ints[n2] = this.ints[n];
        }
    }

    private static int arraySize(int n) {
        return Math.max(2, ParsedValues.nextPowerOfTwo((int)Math.ceil((float)n / 0.75f)));
    }

    private static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        return (n | n >> 16) + 1;
    }

    private static int maxFill(int n) {
        return Math.min((int)Math.ceil((float)n * 0.75f), n - 1);
    }

    private static int mix(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >>> 16;
    }

    private void rehash(int n) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int[] nArray = this.ints;
        int n2 = n - 1;
        Object[] objectArray3 = new Object[n];
        Object[] objectArray4 = objectArray2 == null ? null : new Object[n];
        int[] nArray2 = new int[n];
        int n3 = this.len;
        int n4 = this.count;
        for (int i = 0; i < n4; ++i) {
            while (objectArray[--n3] == null) {
            }
            int n5 = ParsedValues.mix(objectArray[n3].hashCode()) & n2;
            if (objectArray3[n5] != null) {
                while (objectArray3[n5 = n5 + 1 & n2] != null) {
                }
            }
            objectArray3[n5] = objectArray[n3];
            if (objectArray2 != null) {
                objectArray4[n5] = objectArray2[n3];
            }
            nArray2[n5] = nArray[n3];
        }
        this.len = n;
        this.mask = n2;
        this.threshold = ParsedValues.maxFill(n);
        this.keys = objectArray3;
        this.values = objectArray4;
        this.ints = nArray2;
    }

    private static ChronoElement<Integer> getIndexedElement(int n) {
        switch (n) {
            case 0: {
                return PlainDate.YEAR;
            }
            case 1: {
                return PlainDate.MONTH_AS_NUMBER;
            }
            case 2: {
                return PlainDate.DAY_OF_MONTH;
            }
            case 3: {
                return PlainTime.DIGITAL_HOUR_OF_DAY;
            }
            case 4: {
                return PlainTime.MINUTE_OF_HOUR;
            }
            case 5: {
                return PlainTime.SECOND_OF_MINUTE;
            }
            case 6: {
                return PlainTime.NANO_OF_SECOND;
            }
        }
        throw new IllegalStateException("No element index: " + n);
    }

    static {
        HashSet hashSet = new HashSet();
        hashSet.add(PlainDate.YEAR);
        hashSet.add(PlainDate.MONTH_AS_NUMBER);
        hashSet.add(PlainDate.DAY_OF_MONTH);
        hashSet.add(PlainTime.DIGITAL_HOUR_OF_DAY);
        hashSet.add(PlainTime.MINUTE_OF_HOUR);
        hashSet.add(PlainTime.SECOND_OF_MINUTE);
        hashSet.add(PlainTime.NANO_OF_SECOND);
        INDEXED_ELEMENTS = Collections.unmodifiableSet(hashSet);
    }

    private class KeySet
    extends AbstractSet<ChronoElement<?>> {
        private KeySet() {
        }

        @Override
        public Iterator<ChronoElement<?>> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ParsedValues.this.count;
        }
    }

    private class KeyIterator
    implements Iterator<ChronoElement<?>> {
        int pos;
        int c;

        private KeyIterator() {
            this.pos = ParsedValues.this.len;
            this.c = ParsedValues.this.count;
        }

        @Override
        public boolean hasNext() {
            return this.c > 0;
        }

        @Override
        public ChronoElement<?> next() {
            if (this.c > 0) {
                Object[] objectArray = ParsedValues.this.keys;
                while (--this.pos >= 0) {
                    if (objectArray[this.pos] == null) continue;
                    --this.c;
                    return (ChronoElement)ChronoElement.class.cast(objectArray[this.pos]);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

