/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.android.spi.AndroidResourceLoader;
import net.time4j.base.ResourceLoader;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public class ApplicationStarter {
    private static final String VERSION = "v3.23-2016g";
    private static final int RELEASE_YEAR = 2016;
    private static final int RELEASE_MONTH = 9;
    private static final int RELEASE_DAY = 23;
    private static final String TIME4A = "time4a";
    private static final AtomicBoolean PREPARED = new AtomicBoolean(false);
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);

    private ApplicationStarter() {
    }

    public static void initialize(Application application) {
        ApplicationStarter.initialize((Context)application, false);
    }

    public static void initialize(Context context, boolean bl) {
        long l;
        long l2 = System.nanoTime();
        Context context2 = context.getApplicationContext();
        ApplicationStarter.prepareAssets(context2);
        PlainDate plainDate = PlainDate.of(2016, 9, 23);
        Log.i((String)TIME4A, (String)("Starting Time4A (v3.23-2016g published on " + plainDate + ")"));
        ApplicationStarter.registerReceiver(context2);
        if (bl) {
            l = System.nanoTime();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayMode displayMode = DisplayMode.FULL;
                    TZID tZID = Timezone.ofSystem().getID();
                    Log.i((String)ApplicationStarter.TIME4A, (String)ChronoFormatter.ofMomentStyle(displayMode, displayMode, Locale.getDefault(), tZID).format(SystemClock.currentMoment()));
                    long l2 = (System.nanoTime() - l) / 1000000L;
                    Log.i((String)ApplicationStarter.TIME4A, (String)("Prefetch-Thread consumed in ms: " + l2));
                }
            };
            Executors.defaultThreadFactory().newThread(runnable).start();
        }
        l = (System.nanoTime() - l2) / 1000000L;
        Log.i((String)TIME4A, (String)("Main-Thread consumed in ms: " + l));
    }

    public static void registerReceiver(Context context) {
        if (!REGISTERED.getAndSet(true)) {
            context.registerReceiver((BroadcastReceiver)new TimezoneChangedReceiver(), new IntentFilter("android.intent.action.TIMEZONE_CHANGED"));
        }
    }

    public static void prepareResources(Application application) {
        ApplicationStarter.prepareAssets((Context)application);
    }

    private static void prepareAssets(Context context) {
        if (!PREPARED.getAndSet(true)) {
            System.setProperty("net.time4j.base.ResourceLoader", "net.time4j.android.spi.AndroidResourceLoader");
            ((AndroidResourceLoader)ResourceLoader.getInstance()).init(context);
        }
    }

    private static class TimezoneChangedReceiver
    extends BroadcastReceiver {
        private TimezoneChangedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getStringExtra("time-zone");
            try {
                TZID tZID = Timezone.of(string).getID();
                Timezone.Cache.refresh();
                Log.i((String)ApplicationStarter.TIME4A, (String)("Event ACTION_TIMEZONE_CHANGED received, system timezone changed to: [" + tZID.canonical() + "]. Changed android timezone was: [" + string + "]"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)ApplicationStarter.TIME4A, (String)("Could not recognize timezone id: [" + string + "]"), (Throwable)illegalArgumentException);
            }
        }
    }
}

