/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class LocalizedGMTProcessor
implements FormatProcessor<TZID> {
    private static final char UNICODE_LRM = '\u200e';
    private final boolean abbreviated;
    private final boolean caseInsensitive;
    private final boolean noPrefix;
    private final Locale locale;
    private final String plusSign;
    private final String minusSign;
    private final char zeroDigit;
    private final Leniency lenientMode;

    LocalizedGMTProcessor(boolean bl) {
        this(bl, true, false, Locale.ROOT, "+", "-", '0', Leniency.SMART);
    }

    private LocalizedGMTProcessor(boolean bl, boolean bl2, boolean bl3, Locale locale, String string, String string2, char c, Leniency leniency) {
        this.abbreviated = bl;
        this.caseInsensitive = bl2;
        this.noPrefix = bl3;
        this.locale = locale;
        this.plusSign = string;
        this.minusSign = string2;
        this.zeroDigit = c;
        this.lenientMode = leniency;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        String string;
        ZonalOffset zonalOffset;
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = LocalizedGMTProcessor.getOffset(chronoDisplay, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of(tZID).getOffset((UnixTime)((Object)chronoDisplay));
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        char c = bl ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        String string2 = bl ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string3 = string = bl ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        if ("ar".equals(locale.getLanguage()) && c == '0') {
            string2 = "\u200e+";
            string = "\u200e-";
        }
        boolean bl2 = bl ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        String string4 = bl2 ? "" : LocalizedGMTProcessor.getGMTPrefix(locale);
        appendable.append(string4);
        int n2 = string4.length();
        int n3 = zonalOffset.getIntegralAmount();
        int n4 = zonalOffset.getFractionalAmount();
        if (bl2 || n3 != 0 || n4 != 0) {
            int n5;
            if (zonalOffset.getSign() == OffsetSign.BEHIND_UTC) {
                appendable.append(string);
                n2 += string.length();
            } else {
                appendable.append(string2);
                n2 += string2.length();
            }
            int n6 = zonalOffset.getAbsoluteHours();
            int n7 = zonalOffset.getAbsoluteMinutes();
            int n8 = zonalOffset.getAbsoluteSeconds();
            if (n6 < 10 && !this.abbreviated) {
                appendable.append(c);
                ++n2;
            }
            String string5 = String.valueOf(n6);
            for (int i = 0; i < string5.length(); ++i) {
                n5 = string5.charAt(i) - 48 + c;
                appendable.append((char)n5);
                ++n2;
            }
            if (n7 != 0 || n8 != 0 || !this.abbreviated) {
                int n9;
                appendable.append(':');
                ++n2;
                if (n7 < 10) {
                    appendable.append(c);
                    ++n2;
                }
                String string6 = String.valueOf(n7);
                for (n5 = 0; n5 < string6.length(); ++n5) {
                    n9 = string6.charAt(n5) - 48 + c;
                    appendable.append((char)n9);
                    ++n2;
                }
                if (n8 != 0) {
                    appendable.append(':');
                    ++n2;
                    if (n8 < 10) {
                        appendable.append(c);
                        ++n2;
                    }
                    String string7 = String.valueOf(n8);
                    for (n9 = 0; n9 < string7.length(); ++n9) {
                        char c2 = (char)(string7.charAt(n9) - 48 + c);
                        appendable.append(c2);
                        ++n2;
                    }
                }
            }
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        ZonalOffset zonalOffset;
        String string;
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        Object object3;
        boolean bl2;
        int n4 = charSequence.length();
        int n5 = parseLog.getPosition();
        int n6 = n5;
        if (n6 >= n4) {
            parseLog.setError(n5, "Missing localized time zone offset.");
            return;
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        boolean bl3 = bl ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        boolean bl4 = bl2 = bl ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        if (!bl3) {
            String string2 = LocalizedGMTProcessor.getGMTPrefix(locale);
            object3 = new String[]{"GMT", string2, "UTC", "UT"};
            boolean bl5 = false;
            object2 = object3;
            n3 = ((String[])object2).length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = object2[n2];
                n = ((String)object).length();
                if (n4 - n6 < n) continue;
                String string3 = charSequence.subSequence(n6, n6 + n).toString();
                if ((!bl2 || !string3.equalsIgnoreCase((String)object)) && (bl2 || !string3.equals(object))) continue;
                bl5 = true;
                n6 += n;
                break;
            }
            if (!bl5) {
                parseLog.setError(n5, "Missing prefix in localized time zone offset: " + string2);
                return;
            }
            if (n6 >= n4) {
                parsedValues.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                parseLog.setPosition(n6);
                return;
            }
        }
        char c = bl ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        object3 = bl ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string4 = string = bl ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        if ("ar".equals(locale.getLanguage()) && c == '0') {
            object3 = "\u200e+";
            string = "\u200e-";
        }
        if ((n3 = LiteralProcessor.subSequenceEquals(charSequence, n6, (CharSequence)object3, bl2)) == -1) {
            n3 = LiteralProcessor.subSequenceEquals(charSequence, n6, string, bl2);
            if (n3 == -1) {
                if (bl3) {
                    parseLog.setError(n5, "Missing sign in localized time zone offset.");
                    return;
                }
                parsedValues.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                parseLog.setPosition(n6);
                return;
            }
            object2 = OffsetSign.BEHIND_UTC;
        } else {
            object2 = OffsetSign.AHEAD_OF_UTC;
        }
        n2 = LocalizedGMTProcessor.parseHours(charSequence, n6 += n3, c);
        if (n2 == -1000) {
            parseLog.setError(n6, "Missing hour part in localized time zone offset.");
            return;
        }
        if (n2 < 0) {
            n2 ^= 0xFFFFFFFF;
            ++n6;
        } else {
            n6 += 2;
        }
        if (n6 >= n4) {
            if (this.abbreviated) {
                parsedValues.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)((Object)object2), n2));
                parseLog.setPosition(n6);
            } else {
                parseLog.setError(n6, "Missing minute part in localized time zone offset.");
            }
            return;
        }
        Object object4 = object = bl ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        if (charSequence.charAt(n6) == ':') {
            ++n6;
        } else {
            if (this.abbreviated) {
                parsedValues.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)((Object)object2), n2));
                parseLog.setPosition(n6);
                return;
            }
            if (((Leniency)((Object)object)).isStrict()) {
                parseLog.setError(n6, "Colon expected in localized time zone offset.");
                return;
            }
        }
        n = LocalizedGMTProcessor.parseTwoDigits(charSequence, n6, c);
        if (n == -1000) {
            parseLog.setError(n6, "Minute part in localized time zone offset does not match expected pattern mm.");
            return;
        }
        int n7 = 0;
        if ((n6 += 2) < n4 && charSequence.charAt(n6) == ':') {
            n6 = (n7 = LocalizedGMTProcessor.parseTwoDigits(charSequence, ++n6, c)) == -1000 ? --n6 : (n6 += 2);
        }
        if (n7 == 0 || n7 == -1000) {
            zonalOffset = ZonalOffset.ofHoursMinutes((OffsetSign)((Object)object2), n2, n);
        } else {
            int n8 = n2 * 3600 + n * 60 + n7;
            if (object2 == OffsetSign.BEHIND_UTC) {
                n8 = -n8;
            }
            zonalOffset = ZonalOffset.ofTotalSeconds(n8);
        }
        parsedValues.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
        parseLog.setPosition(n6);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(AttributeQuery attributeQuery, int n) {
        return new LocalizedGMTProcessor(this.abbreviated, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT), attributeQuery.get(AttributeSet.PLUS_SIGN, "+"), attributeQuery.get(AttributeSet.MINUS_SIGN, "-"), attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
    }

    private static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getIsoInstance(locale);
        if (calendarText.getTextForms().isEmpty()) {
            return "GMT";
        }
        return calendarText.getTextForms().get("prefixGMTOffset");
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        TZID tZID;
        if (attributeQuery.contains(Attributes.TIMEZONE_ID) && (tZID = attributeQuery.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
            return (ZonalOffset)tZID;
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseTwoDigits(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                return -1000;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                return -1000;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    private static int parseHours(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }
}

