/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.Computus;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearStrategy;

public enum NewYearRule {
    BEGIN_OF_JANUARY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 1, 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            return historicDate.getYearOfEra();
        }
    }
    ,
    BEGIN_OF_MARCH{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 3, 1);
        }
    }
    ,
    BEGIN_OF_SEPTEMBER{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n - 1, 9, 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            HistoricEra historicEra = historicDate.getEra();
            int n = historicDate.getYearOfEra();
            HistoricDate historicDate2 = newYearStrategy.newYear(historicEra, n + 1);
            int n2 = n;
            if (historicDate.compareTo(historicDate2) >= 0) {
                ++n2;
            }
            return n2;
        }
    }
    ,
    CHRISTMAS_STYLE{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n - 1, 12, 25);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n = historicDate.getYearOfEra();
            HistoricDate historicDate2 = newYearStrategy.newYear(historicDate.getEra(), n + 1);
            int n2 = n;
            if (historicDate.compareTo(historicDate2) >= 0) {
                ++n2;
            }
            return n2;
        }
    }
    ,
    EASTER_STYLE{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            int n2 = historicEra.annoDomini(n);
            int n3 = Computus.EASTERN.marchDay(n2) - 1;
            int n4 = 3;
            if (n3 > 31) {
                ++n4;
                n3 -= 31;
            }
            return HistoricDate.of(historicEra, n, n4, n3);
        }
    }
    ,
    GOOD_FRIDAY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            int n2 = historicEra.annoDomini(n);
            int n3 = Computus.EASTERN.marchDay(n2) - 2;
            int n4 = 3;
            if (n3 > 31) {
                ++n4;
                n3 -= 31;
            }
            return HistoricDate.of(historicEra, n, n4, n3);
        }
    }
    ,
    MARIA_ANUNCIATA{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 3, 25);
        }
    }
    ,
    CALCULUS_PISANUS{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return MARIA_ANUNCIATA.newYear(historicEra, n + 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n = historicDate.getYearOfEra() - 1;
            HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n);
            int n2 = n;
            if (historicDate.compareTo(historicDate2) < 0) {
                --n2;
            }
            return n2;
        }

        @Override
        int standardYear(boolean bl, NewYearStrategy newYearStrategy, HistoricEra historicEra, int n, int n2, int n3) {
            return MARIA_ANUNCIATA.standardYear(bl, newYearStrategy, historicEra, n + 1, n2, n3);
        }
    }
    ,
    EPIPHANY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 1, 6);
        }
    };

    private static final int COUNCIL_OF_TOURS = 567;

    public NewYearStrategy until(int n) {
        if (n <= 567) {
            throw new IllegalArgumentException("Defining New-Year-strategy is not supported before Council of Tours in AD 567.");
        }
        NewYearStrategy newYearStrategy = new NewYearStrategy(this, n);
        if (this != BEGIN_OF_JANUARY) {
            NewYearStrategy newYearStrategy2 = new NewYearStrategy(BEGIN_OF_JANUARY, 567);
            newYearStrategy = newYearStrategy2.and(newYearStrategy);
        }
        return newYearStrategy;
    }

    abstract HistoricDate newYear(HistoricEra var1, int var2);

    int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
        int n = historicDate.getYearOfEra();
        HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n);
        int n2 = n;
        if (historicDate.compareTo(historicDate2) < 0) {
            --n2;
        }
        return n2;
    }

    int standardYear(boolean bl, NewYearStrategy newYearStrategy, HistoricEra historicEra, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 >= 5 && n2 <= 8) {
            return n;
        }
        HistoricDate historicDate = this.newYear(historicEra, n);
        HistoricDate historicDate2 = newYearStrategy.newYear(historicEra, n + 1);
        HistoricDate historicDate3 = HistoricDate.of(historicEra, n, n2, n3);
        if (n2 <= 4) {
            HistoricDate historicDate4 = HistoricDate.of(historicEra, n + 1, n2, n3);
            n5 = historicDate3.compareTo(historicDate) >= 0 ? n : n + 1;
            n4 = historicDate4.compareTo(historicDate2) >= 0 ? n : n + 1;
        } else {
            HistoricDate historicDate5 = HistoricDate.of(historicEra, n - 1, n2, n3);
            n5 = historicDate5.compareTo(historicDate) >= 0 ? n - 1 : n;
            int n6 = n4 = historicDate3.compareTo(historicDate2) >= 0 ? n - 1 : n;
        }
        if (n5 > n4) {
            throw new IllegalArgumentException("Invalid date due to changing new year rule (year too short to cover month and day-of-month): " + historicDate3);
        }
        return bl ? n5 : n4;
    }
}

