/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Collections;
import java.util.Map;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;

final class RelatedGregorianYearRule<T extends ChronoEntity<T>>
implements ElementRule<T, Integer> {
    private static final String KEY_CALENDRICAL = "calendrical";
    private final Map<String, ? extends CalendarSystem<T>> map;
    private final ChronoElement<Integer> dayOfYear;

    RelatedGregorianYearRule(CalendarSystem<T> calendarSystem, ChronoElement<Integer> chronoElement) {
        this.map = Collections.singletonMap(KEY_CALENDRICAL, calendarSystem);
        this.dayOfYear = chronoElement;
    }

    RelatedGregorianYearRule(Map<String, ? extends CalendarSystem<T>> map, ChronoElement<Integer> chronoElement) {
        this.map = map;
        this.dayOfYear = chronoElement;
    }

    @Override
    public Integer getValue(T t) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t);
        Object t2 = ((ChronoEntity)t).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t2));
    }

    @Override
    public Integer getMinimum(T t) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t);
        long l = calendarSystem.getMinimumSinceUTC();
        Object t2 = ((ChronoEntity)calendarSystem.transform(l)).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t2));
    }

    @Override
    public Integer getMaximum(T t) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t);
        long l = calendarSystem.getMaximumSinceUTC();
        Object t2 = ((ChronoEntity)calendarSystem.transform(l)).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t2));
    }

    @Override
    public boolean isValid(T t, Integer n) {
        return this.getValue(t).equals(n);
    }

    @Override
    public T withValue(T t, Integer n, boolean bl) {
        if (this.isValid(t, n)) {
            return t;
        }
        throw new IllegalArgumentException("The related gregorian year is read-only.");
    }

    @Override
    public ChronoElement<?> getChildAtFloor(T t) {
        return null;
    }

    @Override
    public ChronoElement<?> getChildAtCeiling(T t) {
        return null;
    }

    private CalendarSystem<T> getCalendarSystem(T t) {
        if (t instanceof CalendarVariant) {
            return this.map.get(((CalendarVariant)CalendarVariant.class.cast(t)).getVariant());
        }
        return this.map.get(KEY_CALENDRICAL);
    }

    private static Integer toGregorianYear(long l) {
        long l2;
        long l3 = EpochDays.MODIFIED_JULIAN_DATE.transform(l, EpochDays.UTC);
        long l4 = MathUtils.safeAdd(l3, 678881L);
        long l5 = MathUtils.floorDivide(l4, 146097);
        int n = MathUtils.floorModulo(l4, 146097);
        if (n == 146096) {
            l2 = (l5 + 1L) * 400L;
        } else {
            int n2 = n / 36524;
            int n3 = n % 36524;
            int n4 = n3 / 1461;
            int n5 = n3 % 1461;
            if (n5 == 1460) {
                l2 = l5 * 400L + (long)(n2 * 100) + (long)((n4 + 1) * 4);
            } else {
                int n6 = n5 / 365;
                int n7 = n5 % 365;
                l2 = l5 * 400L + (long)(n2 * 100) + (long)(n4 * 4) + (long)n6;
                int n8 = (n7 + 31) * 5 / 153 + 2;
                if (n8 > 12) {
                    ++l2;
                }
            }
        }
        return MathUtils.safeCast(l2);
    }
}

