/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.text.ParsePosition;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.expert.ParsedValues;

public class ParseLog {
    private ParsePosition pp;
    private String errorMessage;
    private ParsedValues rawValues;
    private Boolean daylightSaving;
    private boolean warning;

    public ParseLog() {
        this(0);
    }

    public ParseLog(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined: " + n);
        }
        this.pp = new ParsePosition(n);
        this.errorMessage = "";
        this.rawValues = null;
        this.daylightSaving = null;
        this.warning = false;
    }

    ParseLog(ParsePosition parsePosition) {
        if (parsePosition.getIndex() < 0) {
            throw new IllegalArgumentException("Undefined position: " + parsePosition.getIndex());
        }
        parsePosition.setErrorIndex(-1);
        this.pp = parsePosition;
        this.errorMessage = "";
        this.rawValues = null;
        this.daylightSaving = null;
        this.warning = false;
    }

    public int getPosition() {
        return this.pp.getIndex();
    }

    public boolean isError() {
        return this.pp.getErrorIndex() != -1;
    }

    public int getErrorIndex() {
        return this.pp.getErrorIndex();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ChronoEntity<?> getRawValues() {
        if (this.rawValues == null) {
            this.rawValues = new ParsedValues(0);
        }
        return this.rawValues;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("[position=");
        stringBuilder.append(this.getPosition());
        stringBuilder.append(", error-index=");
        stringBuilder.append(this.getErrorIndex());
        stringBuilder.append(", error-message=\"");
        stringBuilder.append(this.errorMessage);
        stringBuilder.append('\"');
        if (this.warning) {
            stringBuilder.append(", warning-active");
        }
        if (this.rawValues != null) {
            stringBuilder.append(", raw-values=");
            stringBuilder.append(this.rawValues);
        }
        if (this.daylightSaving != null) {
            stringBuilder.append(", daylight-saving=");
            stringBuilder.append(this.daylightSaving);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void setPosition(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined position: " + n);
        }
        this.pp.setIndex(n);
    }

    public void setError(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Undefined error index: " + n);
        }
        this.errorMessage = string == null || string.isEmpty() ? "Error occurred at position: " + n : string;
        this.pp.setErrorIndex(n);
    }

    public void setWarning() {
        if (!this.isError()) {
            this.errorMessage = "Warning state active.";
            this.pp.setErrorIndex(this.getPosition());
        }
        this.warning = true;
    }

    public void reset() {
        this.pp.setIndex(0);
        this.clearError();
        this.clearWarning();
        this.rawValues = null;
        this.daylightSaving = null;
    }

    ParsedValues getRawValues0() {
        return this.rawValues;
    }

    void clearError() {
        this.pp.setErrorIndex(-1);
        this.errorMessage = "";
    }

    void setRawValues(ParsedValues parsedValues) {
        this.rawValues = parsedValues;
    }

    void setDaylightSaving(boolean bl) {
        this.daylightSaving = bl;
    }

    Boolean getDSTInfo() {
        return this.daylightSaving;
    }

    boolean isWarning() {
        return this.warning;
    }

    void clearWarning() {
        this.warning = false;
    }

    ParsePosition getPP() {
        return this.pp;
    }
}

