/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;

public final class TextAccessor {
    private final List<String> textForms;

    TextAccessor(String[] stringArray, Locale locale) {
        this.textForms = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public String print(Enum<?> enum_) {
        int n = enum_.ordinal();
        if (this.textForms.size() <= n) {
            return enum_.name();
        }
        return this.textForms.get(n);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz) {
        return this.parse(charSequence, parsePosition, clazz, true, false);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, Leniency leniency) {
        boolean bl = true;
        boolean bl2 = false;
        if (leniency == Leniency.STRICT) {
            bl = false;
        } else if (leniency == Leniency.LAX) {
            bl2 = true;
        }
        return this.parse(charSequence, parsePosition, clazz, bl, bl2);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, AttributeQuery attributeQuery) {
        boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
        return this.parse(charSequence, parsePosition, clazz, bl, bl2);
    }

    public String toString() {
        int n = this.textForms.size();
        StringBuilder stringBuilder = new StringBuilder(n * 16 + 2);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.textForms.get(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, boolean bl, boolean bl2) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = this.textForms.size();
        int n2 = parsePosition.getIndex();
        int n3 = charSequence.length();
        int n4 = 0;
        Enum enum_ = null;
        for (int i = 0; i < enumArray.length; ++i) {
            String string = i >= n ? enumArray[i].name() : this.textForms.get(i);
            int n5 = n2;
            int n6 = string.length();
            boolean bl3 = true;
            for (int j = 0; bl3 && j < n6; ++j) {
                if (n2 + j >= n3) {
                    bl3 = false;
                    continue;
                }
                char c = charSequence.charAt(n2 + j);
                char c2 = string.charAt(j);
                if (bl) {
                    bl3 = c == c2 || this.compareIgnoreCase(c, c2);
                } else {
                    boolean bl4 = bl3 = c == c2;
                }
                if (!bl3) continue;
                ++n5;
            }
            if (bl2 || n6 == 1) {
                if (n4 < n5 - n2) {
                    n4 = n5 - n2;
                    enum_ = enumArray[i];
                    continue;
                }
                if (n4 != n5 - n2) continue;
                enum_ = null;
                continue;
            }
            if (!bl3) continue;
            assert (n5 == n2 + n6);
            parsePosition.setIndex(n5);
            return (V)enumArray[i];
        }
        if (enum_ == null) {
            parsePosition.setErrorIndex(n2);
        } else {
            parsePosition.setIndex(n2 + n4);
        }
        return (V)enum_;
    }

    private boolean compareIgnoreCase(char c, char c2) {
        if (c >= 'a' && c <= 'z') {
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 97 - 65);
            }
            return c == c2;
        }
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 97 - 65);
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 97 - 65);
            }
            return c == c2;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }
}

