/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.base.MathUtils;
import net.time4j.calendar.CopticCalendar;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.EthiopianEra;
import net.time4j.calendar.EthiopianTime;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.JulianCalendar;
import net.time4j.calendar.MinguoCalendar;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.ThaiSolarCalendar;
import net.time4j.history.HistoricEra;

final class SPX
implements Externalizable {
    static final int HIJRI = 1;
    static final int PERSIAN = 2;
    static final int COPTIC = 3;
    static final int ETHIOPIAN_DATE = 4;
    static final int ETHIOPIAN_TIME = 5;
    static final int MINGUO = 6;
    static final int JULIAN = 7;
    static final int THAI_SOLAR = 8;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 1: {
                this.writeHijri(objectOutput);
                break;
            }
            case 2: {
                this.writePersian(objectOutput);
                break;
            }
            case 3: {
                this.writeCoptic(objectOutput);
                break;
            }
            case 4: {
                this.writeEthiopianDate(objectOutput);
                break;
            }
            case 5: {
                this.writeEthiopianTime(objectOutput);
                break;
            }
            case 6: {
                this.writeMinguo(objectOutput);
                break;
            }
            case 7: {
                this.writeJulian(objectOutput);
                break;
            }
            case 8: {
                this.writeThaiSolar(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 1: {
                this.obj = this.readHijri(objectInput);
                break;
            }
            case 2: {
                this.obj = this.readPersian(objectInput);
                break;
            }
            case 3: {
                this.obj = this.readCoptic(objectInput);
                break;
            }
            case 4: {
                this.obj = this.readEthiopianDate(objectInput);
                break;
            }
            case 5: {
                this.obj = this.readEthiopianTime(objectInput);
                break;
            }
            case 6: {
                this.obj = this.readMinguo(objectInput);
                break;
            }
            case 7: {
                this.obj = this.readJulian(objectInput);
                break;
            }
            case 8: {
                this.obj = this.readThaiSolar(objectInput);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHijri(ObjectOutput objectOutput) throws IOException {
        HijriCalendar hijriCalendar = (HijriCalendar)this.obj;
        objectOutput.writeUTF(hijriCalendar.getVariant());
        objectOutput.writeUTF(HijriCalendar.getVersion(hijriCalendar.getVariant()));
        objectOutput.writeInt(hijriCalendar.getYear());
        objectOutput.writeByte(hijriCalendar.getMonth().getValue());
        objectOutput.writeByte(hijriCalendar.getDayOfMonth());
    }

    private HijriCalendar readHijri(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = objectInput.readUTF();
        if (!HijriCalendar.getVersion(string).equals(string2)) {
            throw new InvalidObjectException("Hijri calendar object with different data version not supported: " + string + "/" + string2);
        }
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return HijriCalendar.of(string, n, (int)by, (int)by2);
    }

    private void writePersian(ObjectOutput objectOutput) throws IOException {
        PersianCalendar persianCalendar = (PersianCalendar)this.obj;
        objectOutput.writeInt(persianCalendar.getYear());
        objectOutput.writeByte(persianCalendar.getMonth().getValue());
        objectOutput.writeByte(persianCalendar.getDayOfMonth());
    }

    private PersianCalendar readPersian(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return PersianCalendar.of(n, by, (int)by2);
    }

    private void writeCoptic(ObjectOutput objectOutput) throws IOException {
        CopticCalendar copticCalendar = (CopticCalendar)this.obj;
        objectOutput.writeInt(copticCalendar.getYear());
        objectOutput.writeByte(copticCalendar.getMonth().getValue());
        objectOutput.writeByte(copticCalendar.getDayOfMonth());
    }

    private CopticCalendar readCoptic(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return CopticCalendar.of(n, by, (int)by2);
    }

    private void writeEthiopianDate(ObjectOutput objectOutput) throws IOException {
        EthiopianCalendar ethiopianCalendar = (EthiopianCalendar)this.obj;
        objectOutput.writeByte(ethiopianCalendar.getEra().ordinal());
        objectOutput.writeInt(ethiopianCalendar.getYear());
        objectOutput.writeByte(ethiopianCalendar.getMonth().getValue());
        objectOutput.writeByte(ethiopianCalendar.getDayOfMonth());
    }

    private EthiopianCalendar readEthiopianDate(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        EthiopianEra ethiopianEra = EthiopianEra.values()[objectInput.readByte()];
        int n = objectInput.readInt();
        byte by = objectInput.readByte();
        byte by2 = objectInput.readByte();
        return EthiopianCalendar.of(ethiopianEra, n, by, (int)by2);
    }

    private void writeEthiopianTime(ObjectOutput objectOutput) throws IOException {
        EthiopianTime ethiopianTime = (EthiopianTime)this.obj;
        int n = ethiopianTime.get(EthiopianTime.DIGITAL_HOUR_OF_DAY) * 3600 + ethiopianTime.getMinute() * 60 + ethiopianTime.getSecond();
        objectOutput.writeInt(n);
    }

    private EthiopianTime readEthiopianTime(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n % 60;
        int n3 = n / 60;
        int n4 = n3 % 60;
        int n5 = n3 / 60;
        PlainTime plainTime = PlainTime.of(n5, n4, n2);
        return EthiopianTime.from(plainTime);
    }

    private void writeMinguo(ObjectOutput objectOutput) throws IOException {
        MinguoCalendar minguoCalendar = (MinguoCalendar)this.obj;
        objectOutput.writeObject(minguoCalendar.toISO());
    }

    private MinguoCalendar readMinguo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PlainDate plainDate = (PlainDate)PlainDate.class.cast(objectInput.readObject());
        return plainDate.transform(MinguoCalendar.class);
    }

    private void writeJulian(ObjectOutput objectOutput) throws IOException {
        JulianCalendar julianCalendar = (JulianCalendar)this.obj;
        objectOutput.writeInt(julianCalendar.getProlepticYear());
        objectOutput.writeInt(julianCalendar.getMonth().getValue());
        objectOutput.writeInt(julianCalendar.getDayOfMonth());
    }

    private JulianCalendar readJulian(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        HistoricEra historicEra = n >= 1 ? HistoricEra.AD : HistoricEra.BC;
        int n4 = n >= 1 ? n : MathUtils.safeSubtract(1, n);
        return JulianCalendar.of(historicEra, n4, n2, n3);
    }

    private void writeThaiSolar(ObjectOutput objectOutput) throws IOException {
        ThaiSolarCalendar thaiSolarCalendar = (ThaiSolarCalendar)this.obj;
        objectOutput.writeObject(thaiSolarCalendar.toISO());
    }

    private ThaiSolarCalendar readThaiSolar(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PlainDate plainDate = (PlainDate)PlainDate.class.cast(objectInput.readObject());
        return plainDate.transform(ThaiSolarCalendar.class);
    }
}

