/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.olson.AFRICA;
import net.time4j.tz.olson.AMERICA;
import net.time4j.tz.olson.ANTARCTICA;
import net.time4j.tz.olson.ASIA;
import net.time4j.tz.olson.ATLANTIC;
import net.time4j.tz.olson.AUSTRALIA;
import net.time4j.tz.olson.EUROPE;
import net.time4j.tz.olson.INDIAN;
import net.time4j.tz.olson.PACIFIC;

public class ZoneNameProviderSPI
implements ZoneProvider {
    private static final Map<String, Set<String>> TERRITORIES;

    @Override
    public Set<String> getAvailableIDs() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        String string = locale.getCountry();
        if (bl && string.equals("US")) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add("America/New_York");
            linkedHashSet.add("America/Chicago");
            linkedHashSet.add("America/Denver");
            linkedHashSet.add("America/Los_Angeles");
            linkedHashSet.add("America/Anchorage");
            linkedHashSet.add("Pacific/Honolulu");
            linkedHashSet.add("America/Adak");
            return Collections.unmodifiableSet(linkedHashSet);
        }
        Set<String> set = TERRITORIES.get(string);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    @Override
    public Map<String, String> getAliases() {
        return Collections.emptyMap();
    }

    @Override
    public String getFallback() {
        return "";
    }

    @Override
    public String getName() {
        return "#STD_ZONE_NAMES";
    }

    @Override
    public String getLocation() {
        return "";
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public TransitionHistory load(String string) {
        return null;
    }

    @Override
    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        Timezone timezone = Timezone.of("java.util.TimeZone~" + string, ZonalOffset.UTC);
        if (timezone.isFixed() && timezone.getOffset(Moment.UNIX_EPOCH).equals(ZonalOffset.UTC)) {
            return "";
        }
        return timezone.getDisplayName(nameStyle, locale);
    }

    private static void addTerritory(Map<String, Set<String>> map, String string, TZID tZID) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            map.put(string, set);
        }
        set.add(tZID.canonical());
    }

    static {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (AFRICA enum_ : AFRICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, enum_.getCountry(), enum_);
        }
        for (Enum enum_ : AMERICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((AMERICA)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : AMERICA.ARGENTINA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "AR", (TZID)((Object)enum_));
        }
        for (Enum enum_ : AMERICA.INDIANA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", (TZID)((Object)enum_));
        }
        for (Enum enum_ : AMERICA.KENTUCKY.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", (TZID)((Object)enum_));
        }
        for (Enum enum_ : AMERICA.NORTH_DAKOTA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", (TZID)((Object)enum_));
        }
        for (Enum enum_ : ANTARCTICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((ANTARCTICA)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : ASIA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((ASIA)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : ATLANTIC.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((ATLANTIC)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : AUSTRALIA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((AUSTRALIA)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : EUROPE.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((EUROPE)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : INDIAN.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((INDIAN)enum_).getCountry(), (TZID)((Object)enum_));
        }
        for (Enum enum_ : PACIFIC.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, ((PACIFIC)enum_).getCountry(), (TZID)((Object)enum_));
        }
        hashMap.put("SJ", Collections.singleton("Arctic/Longyearbyen"));
        TERRITORIES = Collections.unmodifiableMap(hashMap);
    }
}

