/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.Locale;
import net.time4j.base.MathUtils;
import net.time4j.format.Leniency;

public enum NumberSystem {
    ARABIC{

        @Override
        public String toNumeral(int n) {
            return Integer.toString(n);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            return Integer.parseInt(string);
        }

        @Override
        public boolean contains(char c) {
            return c >= '0' && c <= '9';
        }
    }
    ,
    ETHIOPIC{

        @Override
        public String toNumeral(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can only convert positive numbers: " + n);
            }
            String string = String.valueOf(n);
            int n2 = string.length() - 1;
            if (n2 % 2 == 0) {
                string = "0" + string;
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n2; i >= 0; --i) {
                char c;
                char c2 = '\u0000';
                char c3 = '\u0000';
                char c4 = string.charAt(n2 - i);
                if ((c = string.charAt(n2 - --i)) != '0') {
                    c3 = (char)(c + 4920);
                }
                if (c4 != '0') {
                    c2 = (char)(c4 + 4929);
                }
                int n3 = i % 4 / 2;
                char c5 = '\u0000';
                if (i != 0) {
                    char c6 = n3 != 0 ? (c3 != '\u0000' || c2 != '\u0000' ? (char)'\u137b' : '\u0000') : (c5 = '\u137c');
                }
                if (c3 == '\u1369' && c2 == '\u0000' && n2 > 1 && (c5 == '\u137b' || i + 1 == n2)) {
                    c3 = '\u0000';
                }
                if (c2 != '\u0000') {
                    stringBuilder.append(c2);
                }
                if (c3 != '\u0000') {
                    stringBuilder.append(c3);
                }
                if (c5 == '\u0000') continue;
                stringBuilder.append(c5);
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = n = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c >= '\u1369' && c < '\u1372') {
                    n3 += '\u0001' + c - 4969;
                    continue;
                }
                if (c >= '\u1372' && c < '\u137b') {
                    n3 += ('\u0001' + c - 4978) * 10;
                    continue;
                }
                if (c == '\u137c') {
                    if (bl && n3 == 0) {
                        n3 = 1;
                    }
                    n2 = NumberSystem.add(n2, n3, n4);
                    n4 = bl ? (n4 *= 100) : (n4 *= 10000);
                    n3 = 0;
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (c != '\u137b') continue;
                n2 = NumberSystem.add(n2, n3, n4);
                n4 *= 100;
                n3 = 0;
                bl = true;
                bl2 = false;
            }
            if ((bl || bl2) && n3 == 0) {
                n3 = 1;
            }
            n2 = NumberSystem.add(n2, n3, n4);
            return n2;
        }

        @Override
        public boolean contains(char c) {
            return c >= '\u1369' && c <= '\u137c';
        }
    }
    ,
    ROMAN{

        @Override
        public String toNumeral(int n) {
            if (n < 1 || n > 3999) {
                throw new IllegalArgumentException("Out of range (1-3999): " + n);
            }
            int n2 = n;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < NUMBERS.length; ++i) {
                while (n2 >= NUMBERS[i]) {
                    stringBuilder.append(LETTERS[i]);
                    n2 -= NUMBERS[i];
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            if (string.isEmpty()) {
                throw new NumberFormatException("Empty Roman numeral.");
            }
            String string2 = string.toUpperCase(Locale.US);
            boolean bl = leniency.isStrict();
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4;
                char c = string2.charAt(n2);
                int n5 = NumberSystem.getValue(c);
                int n6 = 1;
                if (n4 == n) {
                    n3 += n5;
                } else {
                    for (n4 = n2 + 1; n4 < n; ++n4) {
                        char c2 = string2.charAt(n4);
                        if (c2 == c) {
                            if (++n6 < 4 || !bl) continue;
                            throw new NumberFormatException("Roman numeral contains more than 3 equal letters in sequence: " + string);
                        }
                        int n7 = NumberSystem.getValue(c2);
                        if (n7 < n5) {
                            n3 += n5 * n6;
                            break;
                        }
                        if (bl && (n6 > 1 || !NumberSystem.isValidCombination(c, c2))) {
                            throw new NumberFormatException("Not conform with modern usage: " + string);
                        }
                        n3 = n3 + n7 - n5 * n6;
                        break;
                    }
                }
                n2 = --n4;
            }
            if (n3 > 3999) {
                throw new NumberFormatException("Roman numbers bigger than 3999 not supported.");
            }
            if (bl) {
                if (n3 >= 900 && string2.contains("DCD")) {
                    throw new NumberFormatException("Roman number contains invalid sequence DCD.");
                }
                if (n3 >= 90 && string2.contains("LXL")) {
                    throw new NumberFormatException("Roman number contains invalid sequence LXL.");
                }
                if (n3 >= 9 && string2.contains("VIV")) {
                    throw new NumberFormatException("Roman number contains invalid sequence VIV.");
                }
            }
            return n3;
        }

        @Override
        public boolean contains(char c) {
            char c2 = Character.toUpperCase(c);
            return c2 == 'I' || c2 == 'V' || c2 == 'X' || c2 == 'L' || c2 == 'C' || c2 == 'D' || c2 == 'M';
        }
    };

    private static final char ETHIOPIC_ONE = '\u1369';
    private static final char ETHIOPIC_TEN = '\u1372';
    private static final char ETHIOPIC_HUNDRED = '\u137b';
    private static final char ETHIOPIC_TEN_THOUSAND = '\u137c';
    private static final int[] NUMBERS;
    private static final String[] LETTERS;

    public String toNumeral(int n) {
        throw new AbstractMethodError();
    }

    public final int toInteger(String string) {
        return this.toInteger(string, Leniency.SMART);
    }

    public int toInteger(String string, Leniency leniency) {
        throw new AbstractMethodError();
    }

    public boolean contains(char c) {
        throw new AbstractMethodError();
    }

    private static int add(int n, int n2, int n3) {
        return MathUtils.safeAdd(n, MathUtils.safeMultiply(n2, n3));
    }

    private static int getValue(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new NumberFormatException("Invalid Roman digit: " + c);
    }

    private static boolean isValidCombination(char c, char c2) {
        switch (c) {
            case 'C': {
                return c2 == 'M' || c2 == 'D';
            }
            case 'X': {
                return c2 == 'C' || c2 == 'L';
            }
            case 'I': {
                return c2 == 'X' || c2 == 'V';
            }
        }
        return false;
    }

    static {
        NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    }
}

