/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.MonthBasedCalendarSystem;
import net.time4j.calendar.SPX;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TextElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="julian")
public final class JulianCalendar
extends Calendrical<Unit, JulianCalendar>
implements LocalizedPatternSupport {
    private static final int YMAX = 999999999;
    private static final int OFFSET = 720200;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    public static final ChronoElement<HistoricDate> DATE = ChronoHistory.PROLEPTIC_JULIAN.date();
    @FormattableElement(format="G")
    public static final ChronoElement<HistoricEra> ERA = ChronoHistory.PROLEPTIC_JULIAN.era();
    @FormattableElement(format="y")
    public static final ChronoElement<Integer> YEAR_OF_ERA = ChronoHistory.PROLEPTIC_JULIAN.yearOfEra();
    @FormattableElement(format="M", standalone="L")
    public static final TextElement<Integer> MONTH_OF_YEAR = ChronoHistory.PROLEPTIC_JULIAN.month();
    @FormattableElement(format="d")
    public static final ChronoElement<Integer> DAY_OF_MONTH = ChronoHistory.PROLEPTIC_JULIAN.dayOfMonth();
    @FormattableElement(format="D")
    public static final ChronoElement<Integer> DAY_OF_YEAR = new StdIntegerDateElement<JulianCalendar>("DAY_OF_YEAR", JulianCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final ChronoElement<Weekday> DAY_OF_WEEK = new StdWeekdayElement<JulianCalendar>(JulianCalendar.class);
    private static final MonthBasedCalendarSystem<JulianCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, JulianCalendar> ENGINE;
    private static final long serialVersionUID = 3038883058279104976L;
    private final transient int prolepticYear;
    private final transient int month;
    private final transient int dom;

    private JulianCalendar(int n, int n2, int n3) {
        this.prolepticYear = n;
        this.month = n2;
        this.dom = n3;
    }

    public static JulianCalendar of(HistoricEra historicEra, int n, int n2, int n3) {
        if (historicEra == null) {
            throw new NullPointerException("Missing Julian era.");
        }
        if (!CALSYS.isValid(historicEra, n, n2, n3)) {
            throw new IllegalArgumentException("Out of bounds: " + JulianCalendar.toString(historicEra, n, n2, n3));
        }
        if (historicEra == HistoricEra.AD) {
            return new JulianCalendar(n, n2, n3);
        }
        return new JulianCalendar(MathUtils.safeSubtract(1, n), n2, n3);
    }

    public static JulianCalendar of(HistoricEra historicEra, int n, Month month, int n2) {
        return JulianCalendar.of(historicEra, n, month.getValue(), n2);
    }

    public HistoricEra getEra() {
        return this.prolepticYear >= 1 ? HistoricEra.AD : HistoricEra.BC;
    }

    public int getYear() {
        return this.prolepticYear >= 1 ? this.prolepticYear : MathUtils.safeSubtract(1, this.prolepticYear);
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return JulianCalendar.lengthOfMonth(this.prolepticYear, this.month);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.prolepticYear % 4 == 0;
    }

    public GeneralTimestamp<JulianCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<JulianCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JulianCalendar) {
            JulianCalendar julianCalendar = (JulianCalendar)object;
            return this.dom == julianCalendar.dom && this.month == julianCalendar.month && this.prolepticYear == julianCalendar.prolepticYear;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.dom + 31 * this.month + 37 * this.prolepticYear;
    }

    @Override
    public String toString() {
        return JulianCalendar.toString(this.getEra(), this.getYear(), this.month, this.dom);
    }

    public static TimeAxis<Unit, JulianCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, JulianCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected JulianCalendar getContext() {
        return this;
    }

    int getProlepticYear() {
        return this.prolepticYear;
    }

    private static String toString(CalendarEra calendarEra, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("julian-");
        stringBuilder.append(calendarEra.name());
        stringBuilder.append('-');
        String string = String.valueOf(n);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    private static int lengthOfMonth(int n, int n2) {
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return n % 4 == 0 ? 29 : 28;
            }
        }
        return 31;
    }

    private Object writeReplace() {
        return new SPX(this, 7);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder<Unit, JulianCalendar> builder = ((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, JulianCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)DATE, (ElementRule)new DateRule())).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule(), Unit.DAYS).appendUnit(Unit.YEARS, new JulianUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit(Unit.MONTHS, new JulianUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.WEEKS, new JulianUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new JulianUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = builder.build();
    }

    private static class JulianUnitRule
    implements UnitRule<JulianCalendar> {
        private final Unit unit;

        JulianUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public JulianCalendar addTo(JulianCalendar julianCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply(l, 12L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)JulianUnitRule.ymValue(julianCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l2, 12));
                    int n2 = MathUtils.floorModulo(l2, 12) + 1;
                    int n3 = Math.min(julianCalendar.dom, JulianCalendar.lengthOfMonth(n, n2));
                    HistoricEra historicEra = n >= 1 ? HistoricEra.AD : HistoricEra.BC;
                    int n4 = n >= 1 ? n : MathUtils.safeSubtract(1, n);
                    return JulianCalendar.of(historicEra, n4, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd(CALSYS.transform(julianCalendar), l);
                    return (JulianCalendar)CALSYS.transform(l3);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(JulianCalendar julianCalendar, JulianCalendar julianCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(julianCalendar, julianCalendar2) / 12;
                }
                case MONTHS: {
                    long l = JulianUnitRule.ymValue(julianCalendar2) - JulianUnitRule.ymValue(julianCalendar);
                    if (l > 0L && julianCalendar2.dom < julianCalendar.dom) {
                        --l;
                    } else if (l < 0L && julianCalendar2.dom > julianCalendar.dom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(julianCalendar, julianCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform(julianCalendar2) - CALSYS.transform(julianCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(JulianCalendar julianCalendar) {
            return julianCalendar.prolepticYear * 12 + julianCalendar.month - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<JulianCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("generic", displayStyle, locale);
        }

        @Override
        public JulianCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (JulianCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public JulianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public JulianCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n;
            if (!chronoEntity.contains(ERA)) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Julian era.");
                return null;
            }
            HistoricEra historicEra = chronoEntity.get(ERA);
            int n2 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n2 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Julian year.");
                return null;
            }
            int n3 = chronoEntity.getInt(MONTH_OF_YEAR);
            if (n3 != Integer.MIN_VALUE && (n = chronoEntity.getInt(DAY_OF_MONTH)) != Integer.MIN_VALUE) {
                if (CALSYS.isValid(historicEra, n2, n3, n)) {
                    return JulianCalendar.of(historicEra, n2, n3, n);
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Julian date.");
            }
            if ((n = chronoEntity.getInt(DAY_OF_YEAR)) != Integer.MIN_VALUE) {
                if (n > 0) {
                    int n4 = 1;
                    int n5 = historicEra == HistoricEra.AD ? n2 : MathUtils.safeSubtract(1, n2);
                    int n6 = 0;
                    while (n4 <= 12) {
                        int n7 = JulianCalendar.lengthOfMonth(n5, n4);
                        if (n > n6 + n7) {
                            ++n4;
                            n6 += n7;
                            continue;
                        }
                        return JulianCalendar.of(historicEra, n2, n4, n - n6);
                    }
                }
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Julian date.");
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(JulianCalendar julianCalendar, AttributeQuery attributeQuery) {
            return julianCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }
    }

    private static class WeekdayRule
    implements ElementRule<JulianCalendar, Weekday> {
        private WeekdayRule() {
        }

        @Override
        public Weekday getValue(JulianCalendar julianCalendar) {
            return julianCalendar.getDayOfWeek();
        }

        @Override
        public Weekday getMinimum(JulianCalendar julianCalendar) {
            return Weekday.SUNDAY;
        }

        @Override
        public Weekday getMaximum(JulianCalendar julianCalendar) {
            return Weekday.SATURDAY;
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, Weekday weekday) {
            return weekday != null;
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, Weekday weekday, boolean bl) {
            Weekmodel weekmodel = Weekmodel.of(Weekday.SUNDAY, 1);
            int n = julianCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (JulianCalendar)julianCalendar.plus(CalendarDays.of(n2 - n));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return null;
        }
    }

    private static class DateRule
    implements ElementRule<JulianCalendar, HistoricDate> {
        private DateRule() {
        }

        @Override
        public HistoricDate getValue(JulianCalendar julianCalendar) {
            return HistoricDate.of(julianCalendar.getEra(), julianCalendar.getYear(), julianCalendar.month, julianCalendar.dom);
        }

        @Override
        public HistoricDate getMinimum(JulianCalendar julianCalendar) {
            return HistoricDate.of(HistoricEra.BC, 999999999, 1, 1);
        }

        @Override
        public HistoricDate getMaximum(JulianCalendar julianCalendar) {
            return HistoricDate.of(HistoricEra.AD, 999999999, 12, 31);
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, HistoricDate historicDate) {
            return CALSYS.isValid(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, HistoricDate historicDate, boolean bl) {
            return JulianCalendar.of(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return null;
        }
    }

    private static class EraRule
    implements ElementRule<JulianCalendar, HistoricEra> {
        private EraRule() {
        }

        @Override
        public HistoricEra getValue(JulianCalendar julianCalendar) {
            return julianCalendar.getEra();
        }

        @Override
        public HistoricEra getMinimum(JulianCalendar julianCalendar) {
            return HistoricEra.BC;
        }

        @Override
        public HistoricEra getMaximum(JulianCalendar julianCalendar) {
            return HistoricEra.AD;
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, HistoricEra historicEra) {
            return julianCalendar.getEra().equals(historicEra);
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, HistoricEra historicEra, boolean bl) {
            if (!this.isValid(julianCalendar, historicEra)) {
                throw new IllegalArgumentException("Julian era cannot be changed.");
            }
            return julianCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<JulianCalendar, Integer> {
        private MonthRule() {
        }

        @Override
        public Integer getValue(JulianCalendar julianCalendar) {
            return julianCalendar.month;
        }

        @Override
        public Integer getMinimum(JulianCalendar julianCalendar) {
            return 1;
        }

        @Override
        public Integer getMaximum(JulianCalendar julianCalendar) {
            return 12;
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 1 && n2 <= 12;
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n2 = n;
            int n3 = JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, n2);
            int n4 = Math.min(julianCalendar.dom, n3);
            return new JulianCalendar(julianCalendar.prolepticYear, n2, n4);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<JulianCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: {
                    return julianCalendar.getYear();
                }
                case 2: {
                    return julianCalendar.dom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < julianCalendar.month; ++i) {
                        n += JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, i);
                    }
                    return n + julianCalendar.dom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(JulianCalendar julianCalendar) {
            switch (this.index) {
                case 0: {
                    return 999999999;
                }
                case 2: {
                    return JulianCalendar.lengthOfMonth(julianCalendar.prolepticYear, julianCalendar.month);
                }
                case 3: {
                    return julianCalendar.prolepticYear % 4 == 0 ? 366 : 365;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(JulianCalendar julianCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(julianCalendar);
            Integer n3 = this.getMaximum(julianCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        @Override
        public JulianCalendar withValue(JulianCalendar julianCalendar, Integer n, boolean bl) {
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = julianCalendar.getEra() == HistoricEra.AD ? n2 : MathUtils.safeSubtract(1, n2);
                    int n4 = JulianCalendar.lengthOfMonth(n3, julianCalendar.month);
                    int n5 = Math.min(julianCalendar.dom, n4);
                    return JulianCalendar.of(julianCalendar.getEra(), n2, julianCalendar.month, n5);
                }
                case 2: {
                    return JulianCalendar.of(julianCalendar.getEra(), julianCalendar.getYear(), julianCalendar.month, (int)n);
                }
                case 3: {
                    int n6 = n;
                    if (n6 >= 1 && n6 <= julianCalendar.lengthOfYear()) {
                        int n7 = n - this.getValue(julianCalendar);
                        return (JulianCalendar)julianCalendar.plus(CalendarDays.of(n7));
                    }
                    throw new IllegalArgumentException("Invalid day of year: " + n);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JulianCalendar julianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JulianCalendar julianCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements MonthBasedCalendarSystem<JulianCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            int n4;
            if (calendarEra == HistoricEra.AD) {
                n4 = n;
            } else if (calendarEra == HistoricEra.BC) {
                n4 = MathUtils.safeSubtract(1, n);
            } else {
                return false;
            }
            if (n < 1 || n > 999999999 || n2 < 1 || n2 > 12 || n3 < 1) {
                return false;
            }
            return n3 <= JulianCalendar.lengthOfMonth(n4, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            int n3;
            if (calendarEra == HistoricEra.AD) {
                n3 = n;
            } else if (calendarEra == HistoricEra.BC) {
                n3 = MathUtils.safeSubtract(1, n);
            } else {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 999999999 && n2 >= 1 && n2 <= 12) {
                return JulianCalendar.lengthOfMonth(n3, n2);
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            int n2;
            if (calendarEra == HistoricEra.AD) {
                n2 = n;
            } else if (calendarEra == HistoricEra.BC) {
                n2 = MathUtils.safeSubtract(1, n);
            } else {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 999999999) {
                return n2 % 4 == 0 ? 366 : 365;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        @Override
        public JulianCalendar transform(long l) {
            int n;
            int n2;
            int n3;
            long l2;
            long l3 = MathUtils.safeAdd(l, 720200L);
            long l4 = MathUtils.floorDivide(l3, 1461);
            int n4 = MathUtils.floorModulo(l3, 1461);
            if (n4 == 1460) {
                l2 = (l4 + 1L) * 4L;
                n3 = 2;
                n2 = 29;
            } else {
                int n5 = n4 / 365;
                n = n4 % 365;
                l2 = l4 * 4L + (long)n5;
                n3 = (n + 31) * 5 / 153 + 2;
                n2 = n - (n3 + 1) * 153 / 5 + 123;
                if (n3 > 12) {
                    ++l2;
                    n3 -= 12;
                }
            }
            HistoricEra historicEra = l2 >= 1L ? HistoricEra.AD : HistoricEra.BC;
            n = MathUtils.safeCast(l2 >= 1L ? l2 : MathUtils.safeSubtract(1L, l2));
            return JulianCalendar.of(historicEra, n, n3, n2);
        }

        @Override
        public long transform(JulianCalendar julianCalendar) {
            long l = julianCalendar.prolepticYear;
            int n = julianCalendar.month;
            if (n < 3) {
                --l;
                n += 12;
            }
            long l2 = l * 365L + MathUtils.floorDivide(l, 4) + (long)((n + 1) * 153 / 5) - 123L + (long)julianCalendar.dom;
            return l2 - 720200L;
        }

        @Override
        public long getMinimumSinceUTC() {
            JulianCalendar julianCalendar = new JulianCalendar(-999999998, 1, 1);
            return this.transform(julianCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            JulianCalendar julianCalendar = new JulianCalendar(999999999, 12, 31);
            return this.transform(julianCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            HistoricEra historicEra = HistoricEra.BC;
            HistoricEra historicEra2 = HistoricEra.AD;
            return Collections.unmodifiableList(Arrays.asList(historicEra, historicEra2));
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.15576E7),
        MONTHS(2629800.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(JulianCalendar julianCalendar, JulianCalendar julianCalendar2) {
            return (int)julianCalendar.until(julianCalendar2, this);
        }
    }
}

