/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;

final class LiteralProcessor
implements FormatProcessor<Void> {
    private final char single;
    private final char alt;
    private final String multi;
    private final AttributeKey<Character> attribute;

    LiteralProcessor(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing literal.");
        }
        this.alt = this.single = string.charAt(0);
        this.attribute = null;
        this.multi = string;
        if (this.single < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
    }

    LiteralProcessor(char c, char c2) {
        this.single = c;
        this.alt = c2;
        this.attribute = null;
        this.multi = null;
        if (c < ' ' || c2 < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
    }

    LiteralProcessor(AttributeKey<Character> attributeKey) {
        if (attributeKey == null) {
            throw new NullPointerException("Missing format attribute.");
        }
        this.alt = this.single = '\u0000';
        this.attribute = attributeKey;
        this.multi = null;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (this.attribute != null) {
            char c = ((Character)formatStep.getAttribute(this.attribute, attributeQuery, null)).charValue();
            appendable.append(c);
        } else if (this.multi == null) {
            appendable.append(this.single);
        } else {
            appendable.append(this.multi);
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        if (this.multi == null) {
            this.parseChar(charSequence, parseLog, attributeQuery, formatStep);
        } else {
            this.parseMulti(charSequence, parseLog, attributeQuery, formatStep);
        }
    }

    private void parseChar(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, FormatStep formatStep) {
        int n = parseLog.getPosition();
        boolean bl = false;
        char c = '\u0000';
        char c2 = this.single;
        if (this.attribute != null) {
            c2 = formatStep.getAttribute(this.attribute, attributeQuery, Character.valueOf('\u0000')).charValue();
        }
        if (n >= charSequence.length() || c2 == '\u0000') {
            bl = true;
        } else {
            boolean bl2;
            c = charSequence.charAt(n);
            char c3 = this.alt;
            if (this.attribute != null && Attributes.DECIMAL_SEPARATOR.name().equals(this.attribute.name()) && Locale.ROOT.equals(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT))) {
                char c4 = c2 == ',' ? (char)'.' : (c3 = c2 == '.' ? (char)',' : (char)c2);
            }
            if (bl2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE).booleanValue()) {
                if (!LiteralProcessor.charEqualsIgnoreCase(c, c2) && !LiteralProcessor.charEqualsIgnoreCase(c, c3)) {
                    bl = true;
                }
            } else {
                boolean bl3 = bl = c != c2 && c != c3;
            }
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("Expected: [");
            stringBuilder.append(c2);
            stringBuilder.append("], found: [");
            if (c != '\u0000') {
                stringBuilder.append(c);
            }
            stringBuilder.append(']');
            parseLog.setError(n, stringBuilder.toString());
        } else {
            parseLog.setPosition(n + 1);
        }
    }

    private void parseMulti(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, FormatStep formatStep) {
        int n = parseLog.getPosition();
        int n2 = this.multi.length();
        boolean bl = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE);
        int n3 = LiteralProcessor.subSequenceEquals(charSequence, n, this.multi, bl);
        if (n3 == -1) {
            StringBuilder stringBuilder = new StringBuilder("Expected: [");
            stringBuilder.append(this.multi);
            stringBuilder.append("], found: [");
            stringBuilder.append(charSequence.subSequence(n, Math.min(n + n2, charSequence.length())));
            stringBuilder.append(']');
            parseLog.setError(n, stringBuilder.toString());
        } else {
            parseLog.setPosition(n + n3);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LiteralProcessor) {
            LiteralProcessor literalProcessor = (LiteralProcessor)object;
            if (this.attribute != null) {
                return this.attribute.equals(literalProcessor.attribute);
            }
            if (this.multi == null) {
                return literalProcessor.multi == null && this.single == literalProcessor.single && this.alt == literalProcessor.alt;
            }
            return this.multi.equals(literalProcessor.multi);
        }
        return false;
    }

    public int hashCode() {
        String string = this.attribute == null ? (this.multi == null ? "" : this.multi) : this.attribute.name();
        return this.single ^ string.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[literal=");
        if (this.attribute != null) {
            stringBuilder.append('{');
            stringBuilder.append(this.attribute);
            stringBuilder.append('}');
        } else if (this.multi == null) {
            stringBuilder.append(this.single);
            if (this.alt != this.single) {
                stringBuilder.append(", alternative=");
                stringBuilder.append(this.alt);
            }
        } else {
            stringBuilder.append(this.multi);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    static int subSequenceEquals(CharSequence charSequence, int n, CharSequence charSequence2, boolean bl) {
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        for (int i = 0; i < n4; ++i) {
            char c = '\u0000';
            char c2 = charSequence2.charAt(i);
            if (LiteralProcessor.isBidi(c2)) continue;
            while (n2 + n < n3 && LiteralProcessor.isBidi(c = charSequence.charAt(n2 + n))) {
                ++n2;
            }
            if (n2 + n >= n3) {
                return -1;
            }
            ++n2;
            if (!(bl ? !LiteralProcessor.charEqualsIgnoreCase(c, c2) : c != c2)) continue;
            return -1;
        }
        while (n2 + n < n3 && LiteralProcessor.isBidi(charSequence.charAt(n2 + n))) {
            ++n2;
        }
        return n2;
    }

    private static boolean charEqualsIgnoreCase(char c, char c2) {
        return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static boolean isBidi(char c) {
        return c == '\u200e' || c == '\u200f' || c == '\u061c';
    }
}

