/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.engine.StdOperator;

public abstract class StdDateElement<V extends Comparable<V>, T extends ChronoEntity<T>>
extends BasicElement<V>
implements StdCalendarElement<V, T> {
    private final Class<T> chrono;
    private final transient char symbol;
    private final transient boolean daywise;

    public StdDateElement(String string, Class<T> clazz, char c, boolean bl) {
        super(string);
        this.chrono = clazz;
        this.symbol = c;
        this.daywise = bl;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ChronoOperator<T> minimized() {
        return StdOperator.minimized(this);
    }

    @Override
    public ChronoOperator<T> maximized() {
        return StdOperator.maximized(this);
    }

    @Override
    public ChronoOperator<T> decremented() {
        if (this.daywise) {
            return new DayOperator(true);
        }
        return StdOperator.decremented(this);
    }

    @Override
    public ChronoOperator<T> incremented() {
        if (this.daywise) {
            return new DayOperator(false);
        }
        return StdOperator.incremented(this);
    }

    @Override
    public ChronoOperator<T> atFloor() {
        return StdOperator.atFloor(this);
    }

    @Override
    public ChronoOperator<T> atCeiling() {
        return StdOperator.atCeiling(this);
    }

    protected Object readResolve() throws ObjectStreamException {
        String string = this.name();
        for (ChronoElement<?> chronoElement : Chronology.lookup(this.chrono).getRegisteredElements()) {
            if (!chronoElement.name().equals(string)) continue;
            return chronoElement;
        }
        throw new InvalidObjectException(string);
    }

    private static class DayOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final boolean backwards;

        DayOperator(boolean bl) {
            this.backwards = bl;
        }

        @Override
        public T apply(T t) {
            long l = ((ChronoEntity)t).get(EpochDays.UTC);
            l = this.backwards ? --l : ++l;
            return ((ChronoEntity)t).with(EpochDays.UTC, l);
        }
    }
}

