/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android.spi;

import android.app.Application;
import android.content.Context;
import android.text.format.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.time4j.android.spi.AndroidTickerSPI;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.service.EthiopianExtension;
import net.time4j.calendar.service.GenericTextProviderSPI;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatEngine;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.PluralProvider;
import net.time4j.format.TextProvider;
import net.time4j.format.UnitPatternProvider;
import net.time4j.format.WeekdataProvider;
import net.time4j.format.internal.ExtendedPatterns;
import net.time4j.i18n.HistoricExtension;
import net.time4j.i18n.IsoTextProviderSPI;
import net.time4j.i18n.PluralProviderSPI;
import net.time4j.i18n.SymbolProviderSPI;
import net.time4j.i18n.UltimateFormatEngine;
import net.time4j.i18n.UnitPatternProviderSPI;
import net.time4j.i18n.WeekdataProviderSPI;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.scale.TickProvider;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.spi.TimezoneRepositoryProviderSPI;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class AndroidResourceLoader
extends ResourceLoader {
    private static final Map<Class<?>, Iterable<?>> PROVIDERS;
    private static final Set<String> MODULES;
    private Application application = null;
    private List<FormatPatternProvider> patterns = Collections.emptyList();

    public void init(Application application) {
        this.application = application;
        AndroidFormatPatterns androidFormatPatterns = new AndroidFormatPatterns();
        this.patterns = Collections.singletonList(androidFormatPatterns);
    }

    @Override
    public URI locate(String string, Class<?> clazz, String string2) {
        try {
            if (MODULES.contains(string)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("net/time4j/");
                stringBuilder.append(string);
                stringBuilder.append('/');
                stringBuilder.append(string2);
                return new URI(stringBuilder.toString());
            }
            URL uRL = clazz.getClassLoader().getResource(string2);
            if (uRL != null) {
                return uRL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream load(URI uRI, boolean bl) {
        try {
            if (uRI == null) {
                return null;
            }
            if (uRI.isAbsolute() || this.application == null) {
                URLConnection uRLConnection = uRI.toURL().openConnection();
                uRLConnection.setUseCaches(false);
                return uRLConnection.getInputStream();
            }
            return this.application.getAssets().open(uRI.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public <S> Iterable<S> services(Class<S> clazz) {
        Iterable<?> iterable = PROVIDERS.get(clazz);
        if (iterable == null) {
            if (clazz == FormatPatternProvider.class) {
                iterable = this.patterns;
            } else {
                return ServiceLoader.load(clazz, clazz.getClassLoader());
            }
        }
        return (Iterable)AndroidResourceLoader.cast(iterable);
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    static {
        HashMap<Class, Iterable<Object>> hashMap = new HashMap<Class, Iterable<Object>>();
        hashMap.put(TextProvider.class, new LazyTextdata());
        hashMap.put(ZoneProvider.class, new LazyZoneData());
        hashMap.put(LeapSecondProvider.class, new LazyLeapseconds());
        hashMap.put(ChronoExtension.class, new LazyExtensions());
        hashMap.put(FormatEngine.class, Collections.singleton(UltimateFormatEngine.INSTANCE));
        hashMap.put(NumberSymbolProvider.class, new LazyNumberSymbols());
        hashMap.put(PluralProvider.class, new LazyPluraldata());
        hashMap.put(UnitPatternProvider.class, Collections.singleton(new UnitPatternProviderSPI()));
        hashMap.put(WeekdataProvider.class, new LazyWeekdata());
        hashMap.put(TickProvider.class, Collections.singleton(new AndroidTickerSPI()));
        PROVIDERS = Collections.unmodifiableMap(hashMap);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("i18n");
        hashSet.add("calendar");
        hashSet.add("tzdata");
        MODULES = Collections.unmodifiableSet(hashSet);
    }

    private static final class ExtensionHolder {
        private static final Iterable<ChronoExtension> ITERABLE;

        private ExtensionHolder() {
        }

        static {
            HistoricExtension historicExtension = new HistoricExtension();
            EthiopianExtension ethiopianExtension = new EthiopianExtension();
            ITERABLE = Collections.unmodifiableList(Arrays.asList(historicExtension, ethiopianExtension));
        }
    }

    private static final class LazyExtensions
    implements Iterable<ChronoExtension> {
        private LazyExtensions() {
        }

        @Override
        public Iterator<ChronoExtension> iterator() {
            return ExtensionHolder.ITERABLE.iterator();
        }
    }

    private static final class NumberSymbolHolder {
        private static final Iterable<NumberSymbolProvider> ITERABLE;

        private NumberSymbolHolder() {
        }

        static {
            SymbolProviderSPI symbolProviderSPI = SymbolProviderSPI.INSTANCE;
            ITERABLE = Collections.singleton(symbolProviderSPI);
        }
    }

    private static final class LazyNumberSymbols
    implements Iterable<NumberSymbolProvider> {
        private LazyNumberSymbols() {
        }

        @Override
        public Iterator<NumberSymbolProvider> iterator() {
            return NumberSymbolHolder.ITERABLE.iterator();
        }
    }

    private static final class PluraldataHolder {
        private static final Iterable<PluralProvider> ITERABLE;

        private PluraldataHolder() {
        }

        static {
            PluralProviderSPI pluralProviderSPI = new PluralProviderSPI();
            ITERABLE = Collections.singleton(pluralProviderSPI);
        }
    }

    private static final class LazyPluraldata
    implements Iterable<PluralProvider> {
        private LazyPluraldata() {
        }

        @Override
        public Iterator<PluralProvider> iterator() {
            return PluraldataHolder.ITERABLE.iterator();
        }
    }

    private static final class LeapsecondHolder {
        private static final Iterable<LeapSecondProvider> ITERABLE;

        private LeapsecondHolder() {
        }

        static {
            LeapSecondProvider leapSecondProvider = null;
            for (ZoneProvider zoneProvider : ZoneDataHolder.ITERABLE) {
                if (!(zoneProvider instanceof LeapSecondProvider)) continue;
                leapSecondProvider = (LeapSecondProvider)LeapSecondProvider.class.cast(zoneProvider);
                break;
            }
            ITERABLE = leapSecondProvider == null ? Collections.emptyList() : Collections.singleton(leapSecondProvider);
        }
    }

    private static final class LazyLeapseconds
    implements Iterable<LeapSecondProvider> {
        private LazyLeapseconds() {
        }

        @Override
        public Iterator<LeapSecondProvider> iterator() {
            return LeapsecondHolder.ITERABLE.iterator();
        }
    }

    private static final class ZoneDataHolder {
        private static final Iterable<ZoneProvider> ITERABLE;

        private ZoneDataHolder() {
        }

        static {
            TimezoneRepositoryProviderSPI timezoneRepositoryProviderSPI = new TimezoneRepositoryProviderSPI();
            ZoneNameProviderSPI zoneNameProviderSPI = new ZoneNameProviderSPI();
            ITERABLE = Collections.unmodifiableList(Arrays.asList(timezoneRepositoryProviderSPI, zoneNameProviderSPI));
        }
    }

    private static final class LazyZoneData
    implements Iterable<ZoneProvider> {
        private LazyZoneData() {
        }

        @Override
        public Iterator<ZoneProvider> iterator() {
            return ZoneDataHolder.ITERABLE.iterator();
        }
    }

    private static final class WeekdataHolder {
        private static final Iterable<WeekdataProvider> ITERABLE;

        private WeekdataHolder() {
        }

        static {
            WeekdataProviderSPI weekdataProviderSPI = new WeekdataProviderSPI();
            ITERABLE = Collections.singletonList(weekdataProviderSPI);
        }
    }

    private static final class LazyWeekdata
    implements Iterable<WeekdataProvider> {
        private LazyWeekdata() {
        }

        @Override
        public Iterator<WeekdataProvider> iterator() {
            return WeekdataHolder.ITERABLE.iterator();
        }
    }

    private class AndroidFormatPatterns
    implements ExtendedPatterns {
        private final ExtendedPatterns delegate = new IsoTextProviderSPI();

        AndroidFormatPatterns() {
        }

        @Override
        public String getDatePattern(DisplayMode displayMode, Locale locale) {
            return this.delegate.getDatePattern(displayMode, locale);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale) {
            return this.getTimePattern(displayMode, locale, false);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale, boolean bl) {
            String string = this.delegate.getTimePattern(displayMode, locale, bl);
            if (Locale.getDefault().equals(locale)) {
                String string2 = string;
                if (displayMode != DisplayMode.SHORT) {
                    string2 = this.delegate.getTimePattern(DisplayMode.SHORT, locale);
                }
                boolean bl2 = string2.indexOf(97) == -1;
                boolean bl3 = DateFormat.is24HourFormat((Context)AndroidResourceLoader.this.application);
                if (bl3 != bl2) {
                    if (bl3) {
                        return this.to24HourFormat(string).replace("  ", " ").trim();
                    }
                    String string3 = locale.getLanguage().equals("en") ? "b" : "B";
                    switch (displayMode) {
                        case FULL: {
                            return "h:mm:ss " + string3 + " zzzz";
                        }
                        case LONG: {
                            return "h:mm:ss " + string3 + " z";
                        }
                        case MEDIUM: {
                            return "h:mm:ss " + string3;
                        }
                    }
                    return "h:mm " + string3;
                }
            }
            return string;
        }

        @Override
        public String getDateTimePattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
            return this.delegate.getDateTimePattern(displayMode, displayMode2, locale);
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            return this.delegate.getIntervalPattern(locale);
        }

        private String to24HourFormat(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = string.length();
            block0: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    stringBuilder.append(c);
                    ++i;
                    while (i < n) {
                        c = string.charAt(i);
                        if (c == '\'') {
                            stringBuilder.append(c);
                            if (i + 1 >= n || string.charAt(i + 1) != '\'') continue block0;
                            ++i;
                        }
                        stringBuilder.append(c);
                        ++i;
                    }
                    continue;
                }
                if (c == 'h') {
                    stringBuilder.append('H');
                    continue;
                }
                if (c == 'a') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }

    private static final class TextdataHolder {
        private static final Iterable<TextProvider> ITERABLE;

        private TextdataHolder() {
        }

        static {
            List<TextProvider> list = Arrays.asList(new IsoTextProviderSPI(), new GenericTextProviderSPI());
            ITERABLE = Collections.unmodifiableList(list);
        }
    }

    private static final class LazyTextdata
    implements Iterable<TextProvider> {
        private LazyTextdata() {
        }

        @Override
        public Iterator<TextProvider> iterator() {
            return TextdataHolder.ITERABLE.iterator();
        }
    }
}

