/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.PlainTime;
import net.time4j.calendar.EthiopianTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;

public class EthiopianExtension
implements ChronoExtension {
    @Override
    public boolean accept(Class<?> clazz) {
        return PlainTime.class.isAssignableFrom(clazz);
    }

    @Override
    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        HashSet<ChronoElement<Integer>> hashSet = new HashSet<ChronoElement<Integer>>();
        hashSet.add(EthiopianTime.ETHIOPIAN_HOUR);
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public <T extends ChronoEntity<T>> T resolve(T t, Locale locale, AttributeQuery attributeQuery) {
        EthiopianTime ethiopianTime;
        if (t.contains(EthiopianTime.ETHIOPIAN_HOUR) && (ethiopianTime = (EthiopianTime)EthiopianTime.axis().createFrom((ChronoEntity)t, attributeQuery, false)) != null) {
            t.with(EthiopianTime.ETHIOPIAN_HOUR, null);
            return t.with(PlainTime.axis().element(), (PlainTime)ethiopianTime.toISO());
        }
        return t;
    }
}

