/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;

final class DecimalProcessor
implements FormatProcessor<BigDecimal> {
    private final FormatProcessor<Void> decimalSeparator = new LiteralProcessor(Attributes.DECIMAL_SEPARATOR);
    private final ChronoElement<BigDecimal> element;
    private final int precision;
    private final int scale;

    DecimalProcessor(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
        this.element = chronoElement;
        this.precision = n;
        this.scale = n2;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Precision must be >= 2: " + n);
        }
        if (n2 >= n) {
            throw new IllegalArgumentException("Precision must be bigger than scale: " + n + "," + n2);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Scale must be bigger than zero.");
        }
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        int n;
        int n2;
        int n3;
        BigDecimal bigDecimal = chronoDisplay.get(this.element).setScale(this.scale, RoundingMode.FLOOR);
        String string = bigDecimal.toPlainString();
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = string.length();
        for (n3 = 0; n3 < n7; ++n3) {
            char c = string.charAt(n3);
            if (c == '.') {
                n6 = n3;
                continue;
            }
            if (n6 >= 0) {
                ++n5;
                continue;
            }
            ++n4;
        }
        n3 = this.precision - this.scale - n4;
        if (n3 < 0) {
            throw new IllegalArgumentException("Integer part of element value exceeds fixed format width: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.precision + 1);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append('0');
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuilder.append(string.charAt(n2));
        }
        this.decimalSeparator.print(chronoDisplay, stringBuilder, attributeQuery, set, formatStep);
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuilder.append(string.charAt(n4 + 1 + n2));
        }
        for (n2 = 0; n2 < this.scale - n5; ++n2) {
            stringBuilder.append('0');
        }
        string = stringBuilder.toString();
        n2 = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        if (n2 != 48) {
            n = n2 - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c < '0' || c > '9') continue;
                cArray[i] = (char)(c + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n8 = string.length();
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        if (n != -1 && n8 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n8));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        Leniency leniency;
        int n2;
        int n3 = charSequence.length();
        int n4 = n2 = parseLog.getPosition();
        int n5 = formatStep.getAttribute(Attributes.PROTECTED_CHARACTERS, attributeQuery, 0);
        if (n5 > 0) {
            n3 -= n5;
        }
        if (n4 >= n3) {
            parseLog.setError(n4, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n6 = Math.min(n3, n4 + 18);
        long l = 0L;
        boolean bl = true;
        int n7 = 0;
        while (n4 + n7 < n6) {
            int n8 = charSequence.charAt(n4 + n7) - c;
            if (n8 >= 0 && n8 <= 9) {
                l = l * 10L + (long)n8;
                ++n7;
                bl = false;
                continue;
            }
            if (!bl) break;
            parseLog.setError(n2, "Digit expected.");
            return;
        }
        if ((leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART)).isStrict() && n7 != this.precision - this.scale) {
            parseLog.setError(n4, "Integer part does not match expected width.");
            return;
        }
        parseLog.setPosition(n4 += n7);
        this.decimalSeparator.parse(charSequence, parseLog, attributeQuery, null, formatStep);
        if (parseLog.isError()) {
            return;
        }
        n6 = Math.min(n3, ++n4 + 18);
        int n9 = 0;
        long l2 = 0L;
        while (n4 + n9 < n6 && (n = charSequence.charAt(n4 + n9) - c) >= 0 && n <= 9) {
            l2 = l2 * 10L + (long)n;
            ++n9;
        }
        if (n9 == 0) {
            parseLog.setError(n4, "Fraction part expected.");
            return;
        }
        if (leniency.isStrict() && n9 != this.scale) {
            parseLog.setError(n4, "Fraction part does not match expected width.");
            return;
        }
        parseLog.setPosition(n4 += n9);
        BigDecimal bigDecimal = new BigDecimal(l);
        BigDecimal bigDecimal2 = new BigDecimal(BigInteger.valueOf(l2), n9);
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2).stripTrailingZeros();
        map.put(this.element, bigDecimal3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DecimalProcessor) {
            DecimalProcessor decimalProcessor = (DecimalProcessor)object;
            return this.element.equals(decimalProcessor.element) && this.precision == decimalProcessor.precision && this.scale == decimalProcessor.scale;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.scale + this.precision * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", precision=");
        stringBuilder.append(this.precision);
        stringBuilder.append(", scale=");
        stringBuilder.append(this.scale);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<BigDecimal> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<BigDecimal> withElement(ChronoElement<BigDecimal> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new DecimalProcessor(chronoElement, this.precision, this.scale);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }
}

