/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.Calendrical;
import net.time4j.tz.TZID;

public abstract class StartOfDay {
    public static final StartOfDay MIDNIGHT = new FixedStartOfDay(0);
    public static final StartOfDay EVENING = new FixedStartOfDay(-21600);

    protected StartOfDay() {
    }

    public static StartOfDay ofFixedDeviation(int n) {
        if (n == 0) {
            return MIDNIGHT;
        }
        if (n == -21600) {
            return EVENING;
        }
        if (n > 43200 || n <= -43200) {
            throw new IllegalArgumentException("Start of day out of range: " + n);
        }
        return new FixedStartOfDay(n);
    }

    public abstract int getDeviation(Calendrical<?, ?> var1, TZID var2);

    private static class FixedStartOfDay
    extends StartOfDay {
        private final int deviation;

        private FixedStartOfDay(int n) {
            this.deviation = n;
        }

        @Override
        public int getDeviation(Calendrical<?, ?> calendrical, TZID tZID) {
            return this.deviation;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof FixedStartOfDay) {
                FixedStartOfDay fixedStartOfDay = (FixedStartOfDay)object;
                return this.deviation == fixedStartOfDay.deviation;
            }
            return false;
        }

        public int hashCode() {
            return this.deviation;
        }

        public String toString() {
            return "FixedStartOfDay[" + this.deviation + "]";
        }
    }
}

