/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.util.List;
import java.util.Map;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;

public final class CalendarFamily<T extends CalendarVariant<T>>
extends Chronology<T> {
    private final Map<String, ? extends CalendarSystem<T>> calendars;

    private CalendarFamily(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<ChronoElement<?>, ElementRule<T, ?>> map, List<ChronoExtension> list, Map<String, ? extends CalendarSystem<T>> map2) {
        super(clazz, chronoMerger, map, list);
        this.calendars = map2;
    }

    @Override
    public boolean hasCalendarSystem() {
        return true;
    }

    @Override
    public CalendarSystem<T> getCalendarSystem() {
        if (this.calendars.size() == 1) {
            return this.calendars.values().iterator().next();
        }
        throw new ChronoException("Cannot determine calendar system without variant.");
    }

    @Override
    public CalendarSystem<T> getCalendarSystem(String string) {
        CalendarSystem<T> calendarSystem = this.calendars.get(string);
        if (calendarSystem == null) {
            return super.getCalendarSystem(string);
        }
        return calendarSystem;
    }

    @Override
    public boolean isSupported(ChronoElement<?> chronoElement) {
        return super.isSupported(chronoElement) || chronoElement instanceof EpochDays;
    }

    public static final class Builder<T extends CalendarVariant<T>>
    extends Chronology.Builder<T> {
        private final Map<String, ? extends CalendarSystem<T>> calendars;

        private Builder(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<String, ? extends CalendarSystem<T>> map) {
            super(clazz, chronoMerger);
            if (map.isEmpty()) {
                throw new IllegalArgumentException("Missing calendar variants.");
            }
            this.calendars = map;
        }

        public static <T extends CalendarVariant<T>> Builder<T> setUp(Class<T> clazz, ChronoMerger<T> chronoMerger, Map<String, ? extends CalendarSystem<T>> map) {
            return new Builder<T>(clazz, chronoMerger, map);
        }

        @Override
        public <V> Builder<T> appendElement(ChronoElement<V> chronoElement, ElementRule<T, V> elementRule) {
            super.appendElement(chronoElement, elementRule);
            return this;
        }

        @Override
        public Builder<T> appendExtension(ChronoExtension chronoExtension) {
            super.appendExtension(chronoExtension);
            return this;
        }

        @Override
        public CalendarFamily<T> build() {
            CalendarFamily calendarFamily = new CalendarFamily(this.chronoType, this.merger, this.ruleMap, this.extensions, this.calendars);
            Chronology.register(calendarFamily);
            return calendarFamily;
        }
    }
}

