/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import net.thisptr.jackson.jq.internal.tree.literal.NullLiteral;
import net.thisptr.jackson.jq.path.Path;

public class BracketFieldAccess
extends FieldAccess {
    private Expression startExpr;
    private Expression endExpr;
    private boolean isRange;

    public BracketFieldAccess(Expression src, Expression atExpr, boolean permissive) {
        super(src, permissive);
        this.startExpr = atExpr != null ? atExpr : new NullLiteral();
        this.isRange = false;
    }

    public BracketFieldAccess(Expression src, Expression startExpr, Expression endExpr, boolean permissive) {
        super(src, permissive);
        this.startExpr = startExpr != null ? startExpr : new NullLiteral();
        this.endExpr = endExpr != null ? endExpr : new NullLiteral();
        this.isRange = true;
    }

    public String toString() {
        if (this.isRange) {
            return String.format("%s[%s : %s]%s", this.target, this.startExpr == null ? "" : this.startExpr, this.endExpr == null ? "" : this.endExpr, this.permissive ? "?" : "");
        }
        return String.format("%s[%s]%s", this.target, this.startExpr, this.permissive ? "?" : "");
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        if (this.isRange) {
            this.startExpr.apply(scope, in, start -> this.endExpr.apply(scope, in, end -> this.target.apply(scope, in, path, (pobj, ppath) -> {
                if ((start.isNumber() || start.isNull()) && (end.isNumber() || end.isNull())) {
                    BracketFieldAccess.emitArrayRangeIndexPath(this.permissive, start, end, pobj, ppath, output, requirePath);
                } else if (!this.permissive) {
                    throw new JsonQueryTypeException("Start and end indices of an %s slice must be numbers", pobj.getNodeType());
                }
            }, requirePath)));
        } else {
            this.startExpr.apply(scope, in, accessor -> this.target.apply(scope, in, path, (pobj, ppath) -> {
                if (accessor.isNumber()) {
                    BracketFieldAccess.emitArrayIndexPath(this.permissive, accessor, pobj, ppath, output, requirePath);
                } else if (accessor.isTextual()) {
                    BracketFieldAccess.emitObjectFieldPath(this.permissive, accessor.asText(), pobj, ppath, output, requirePath);
                } else if (accessor.isArray()) {
                    BracketFieldAccess.emitArrayIndexOfPath(this.permissive, accessor, pobj, ppath, output, requirePath);
                } else if (!this.permissive) {
                    throw new JsonQueryTypeException("Cannot index %s with %s", pobj.getNodeType(), accessor.getNodeType());
                }
            }, requirePath));
        }
    }
}

