/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.module.loaders;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.module.BuiltinModule;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.module.ModuleLoader;

public class BuiltinModuleLoader
implements ModuleLoader {
    private final Map<String, Module> pathAndModules = new HashMap<String, Module>();
    private static final BuiltinModuleLoader INSTANCE = new BuiltinModuleLoader(Module.class.getClassLoader());

    public static BuiltinModuleLoader getInstance() {
        return INSTANCE;
    }

    public BuiltinModuleLoader(ClassLoader classLoader) {
        for (Module module : ServiceLoader.load(Module.class, classLoader)) {
            BuiltinModule annotation = module.getClass().getAnnotation(BuiltinModule.class);
            if (annotation == null) continue;
            this.pathAndModules.put(annotation.path(), module);
        }
    }

    private static boolean hasSearchPathOverride(JsonNode metadata) {
        JsonNode search;
        return metadata != null && (search = metadata.get("search")) != null;
    }

    @Override
    public Module loadModule(Module caller, String path, JsonNode metadata) throws JsonQueryException {
        if (BuiltinModuleLoader.hasSearchPathOverride(metadata)) {
            return null;
        }
        return this.pathAndModules.get(path);
    }

    @Override
    public JsonNode loadData(Module caller, String path, JsonNode metadata) {
        return null;
    }

    public Map<String, Module> loadAllModules() {
        return new HashMap<String, Module>(this.pathAndModules);
    }
}

