/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.FixedScopeQuery;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

public class JsonQueryFunction
implements Function {
    private Expression body;
    private List<String> params;
    private String name;
    private Scope closure;

    public JsonQueryFunction(String name, List<String> params, Expression body, Scope closure) {
        this.name = name;
        this.params = params;
        this.body = body;
        this.closure = closure;
    }

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkArgumentCount(this.name, args, this.params.size());
        Scope fnScope = Scope.newChildScope(this.closure);
        fnScope.addFunction(this.name, this.params.size(), this);
        this.pathRecursive(output, fnScope, scope, args, in, path, 0);
    }

    private void pathRecursive(PathOutput output, Scope fnScope, Scope scope, List<Expression> args, JsonNode in, Path path, int i) throws JsonQueryException {
        if (i == this.params.size()) {
            this.body.apply(fnScope, in, path, output, false);
        } else {
            String param = this.params.get(i);
            if (param.startsWith("$")) {
                String argname = param.substring(1);
                args.get(i).apply(scope, in, path, (argvalue, argpath) -> {
                    fnScope.setValueWithPath(argname, argvalue, argpath);
                    this.pathRecursive(output, fnScope, scope, args, in, path, i + 1);
                }, false);
            } else {
                fnScope.addFunction(param, 0, new JsonQueryFunction(param, Collections.emptyList(), new FixedScopeQuery(scope, args.get(i)), fnScope));
                this.pathRecursive(output, fnScope, scope, args, in, path, i + 1);
            }
        }
    }
}

