/* ExpressionParser.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionParser.java */
        package net.thisptr.jackson.jq.internal.javacc;

        import java.io.StringReader;
        import java.util.List;
        import java.util.Stack;
        import java.util.ArrayList;

        import net.thisptr.jackson.jq.Expression;
        import net.thisptr.jackson.jq.Version;
        import net.thisptr.jackson.jq.internal.misc.Pair;
        import net.thisptr.jackson.jq.internal.tree.*;
        import net.thisptr.jackson.jq.internal.tree.binaryop.*;
        import net.thisptr.jackson.jq.internal.tree.literal.*;
        import net.thisptr.jackson.jq.internal.tree.fieldaccess.*;
        import net.thisptr.jackson.jq.internal.tree.matcher.*;
        import net.thisptr.jackson.jq.internal.tree.matcher.matchers.*;
        import net.thisptr.jackson.jq.internal.javacc.TokenMgrError;
        import net.thisptr.jackson.jq.exception.JsonQueryException;

        @SuppressWarnings("unused")
        public class ExpressionParser implements ExpressionParserConstants {
                private Version version;

                public static Expression compile(final String line, final Version version) throws JsonQueryException {
                        try {
                                final ExpressionParser parser = new ExpressionParser(new StringReader(line));
                                parser.version = version;
                                return parser.Start();
                        } catch (TokenMgrError e) {
                                throw new JsonQueryException("Cannot compile query: " + line, e);
                        } catch (Exception e) {
                                throw new JsonQueryException("Cannot compile query: " + line, e);
                        }
                }

  final public String KeywordAsString() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_IF:{
      token = jj_consume_token(KEYWORD_IF);
      break;
      }
    case KEYWORD_THEN:{
      token = jj_consume_token(KEYWORD_THEN);
      break;
      }
    case KEYWORD_ELIF:{
      token = jj_consume_token(KEYWORD_ELIF);
      break;
      }
    case KEYWORD_ELSE:{
      token = jj_consume_token(KEYWORD_ELSE);
      break;
      }
    case KEYWORD_END:{
      token = jj_consume_token(KEYWORD_END);
      break;
      }
    case KEYWORD_AS:{
      token = jj_consume_token(KEYWORD_AS);
      break;
      }
    case KEYWORD_DEF:{
      token = jj_consume_token(KEYWORD_DEF);
      break;
      }
    case BOOLEAN_LITERAL_TRUE:{
      token = jj_consume_token(BOOLEAN_LITERAL_TRUE);
      break;
      }
    case BOOLEAN_LITERAL_FALSE:{
      token = jj_consume_token(BOOLEAN_LITERAL_FALSE);
      break;
      }
    case OP_AND:{
      token = jj_consume_token(OP_AND);
      break;
      }
    case OP_OR:{
      token = jj_consume_token(OP_OR);
      break;
      }
    case NULL_LITERAL:{
      token = jj_consume_token(NULL_LITERAL);
      break;
      }
    case KEYWORD_REDUCE:{
      token = jj_consume_token(KEYWORD_REDUCE);
      break;
      }
    case KEYWORD_FOREACH:{
      token = jj_consume_token(KEYWORD_FOREACH);
      break;
      }
    case KEYWORD_TRY:{
      token = jj_consume_token(KEYWORD_TRY);
      break;
      }
    case KEYWORD_CATCH:{
      token = jj_consume_token(KEYWORD_CATCH);
      break;
      }
    case KEYWORD_LABEL:{
      token = jj_consume_token(KEYWORD_LABEL);
      break;
      }
    case KEYWORD_BREAK:{
      token = jj_consume_token(KEYWORD_BREAK);
      break;
      }
    case KEYWORD_IMPORT:{
      token = jj_consume_token(KEYWORD_IMPORT);
      break;
      }
    case KEYWORD_INCLUDE:{
      token = jj_consume_token(KEYWORD_INCLUDE);
      break;
      }
    case KEYWORD_MODULE:{
      token = jj_consume_token(KEYWORD_MODULE);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
}

  final public String IdentifierAsString() throws ParseException {Token token;
    token = jj_consume_token(IDENTIFIER);
{if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
}

  final public String KeywordOrIdentifier() throws ParseException {String text;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:{
      text = KeywordAsString();
      break;
      }
    case IDENTIFIER:{
      text = IdentifierAsString();
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return text;}
    throw new Error("Missing return statement in function");
}

  final public ModuleDirective ModuleDirective() throws ParseException {Expression metadata;
    jj_consume_token(KEYWORD_MODULE);
    metadata = Expression();
{if ("" != null) return new ModuleDirective(metadata);}
    throw new Error("Missing return statement in function");
}

  final public ImportStatement ImportStatement() throws ParseException {Expression pathExpr;
        String path;
        String name;
        Expression metadata = null;
        boolean dollarImport = false;
    jj_consume_token(KEYWORD_IMPORT);
    pathExpr = StringInterpolation();
if (!(pathExpr instanceof StringLiteral))
                        {if (true) throw new IllegalStateException("Import path must be constant");}
                path = ((StringLiteral) pathExpr).value().asText();
    jj_consume_token(KEYWORD_AS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
dollarImport = true;
      name = IdentifierAsString();
      break;
      }
    case IDENTIFIER:{
      name = IdentifierAsString();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      metadata = Expression();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
{if ("" != null) return new ImportStatement(path, dollarImport, name, metadata);}
    throw new Error("Missing return statement in function");
}

  final public ImportStatement IncludeStatement() throws ParseException {Expression pathExpr;
        String path;
        Expression metadata = null;
    jj_consume_token(KEYWORD_INCLUDE);
    pathExpr = StringInterpolation();
if (!(pathExpr instanceof StringLiteral))
                        {if (true) throw new IllegalStateException("Include path must be constant");}
                path = ((StringLiteral) pathExpr).value().asText();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      metadata = Expression();
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
{if ("" != null) return new ImportStatement(path, false, null, metadata);}
    throw new Error("Missing return statement in function");
}

  final public Expression Start() throws ParseException {ImportStatement imp;
        ModuleDirective moduleDirective = null;
        final List<ImportStatement> imports = new ArrayList<ImportStatement>();
        Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_MODULE:{
      moduleDirective = ModuleDirective();
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_IMPORT:
      case KEYWORD_INCLUDE:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_IMPORT:{
        imp = ImportStatement();
        break;
        }
      case KEYWORD_INCLUDE:{
        imp = IncludeStatement();
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
imports.add(imp);
      jj_consume_token(SEMICOLON);
    }
    expr = Expression();
    jj_consume_token(0);
if (moduleDirective == null && imports.isEmpty())
                        {if ("" != null) return expr;}
                {if ("" != null) return new TopLevelExpression(moduleDirective, imports, expr);}
    throw new Error("Missing return statement in function");
}

  final public Expression Expression() throws ParseException {PipeComponent component;
        List<PipeComponent> components = new ArrayList<PipeComponent>();
    component = PipeComponent();
components.add(component);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PIPE:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_2;
      }
      jj_consume_token(PIPE);
      component = PipeComponent();
components.add(component);
    }
if (!component.canTerminatePipe()) {
                        if (components.size() > 1) {
                                {if (true) throw new IllegalStateException("Pipe cannot be terminated by assignment or label: | " + component);}
                        } else {
                                {if (true) throw new IllegalStateException("Assignment or label must be followed by pipes: " + component);}
                        }
                }
                if (components.size() == 1 && (component instanceof TransformPipeComponent))
                        {if ("" != null) return ((TransformPipeComponent) component).expr;}
                {if ("" != null) return new PipedQuery(components);}
    throw new Error("Missing return statement in function");
}

  final public Expression JsonQueryWithoutComma() throws ParseException {PipeComponent component;
        List<PipeComponent> components = new ArrayList<PipeComponent>();
    component = PipeComponentWithoutComma();
components.add(component);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PIPE:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_3;
      }
      jj_consume_token(PIPE);
      component = PipeComponentWithoutComma();
components.add(component);
    }
if (!component.canTerminatePipe()) {
                        if (components.size() > 1) {
                                {if (true) throw new IllegalStateException("Pipe cannot be terminated by assignment or label: | " + component);}
                        } else {
                                {if (true) throw new IllegalStateException("Assignment or label must be followed by pipes: " + component);}
                        }
                }
                if (components.size() == 1 && (component instanceof TransformPipeComponent))
                        {if ("" != null) return ((TransformPipeComponent) component).expr;}
                {if ("" != null) return new PipedQuery(components);}
    throw new Error("Missing return statement in function");
}

  final public PipeComponent PipeComponent() throws ParseException {String name;
        Expression expr;
        PatternMatcher matcher;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_LABEL:{
      jj_consume_token(KEYWORD_LABEL);
      jj_consume_token(DOLLAR);
      name = IdentifierAsString();
{if ("" != null) return new LabelPipeComponent(name);}
      break;
      }
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      expr = TupleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_AS:{
        jj_consume_token(KEYWORD_AS);
        matcher = Matcher();
{if ("" != null) return new AssignPipeComponent(expr, matcher);}
        break;
        }
      default:
        jj_la1[10] = jj_gen;
{if ("" != null) return new TransformPipeComponent(expr);}
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public PipeComponent PipeComponentWithoutComma() throws ParseException {String name;
        Expression expr;
        PatternMatcher matcher;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_LABEL:{
      jj_consume_token(KEYWORD_LABEL);
      jj_consume_token(DOLLAR);
      name = IdentifierAsString();
{if ("" != null) return new LabelPipeComponent(name);}
      break;
      }
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      expr = BinaryOperatorExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_AS:{
        jj_consume_token(KEYWORD_AS);
        matcher = Matcher();
{if ("" != null) return new AssignPipeComponent(expr, matcher);}
        break;
        }
      default:
        jj_la1[12] = jj_gen;
{if ("" != null) return new TransformPipeComponent(expr);}
      }
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Expression TupleExpression() throws ParseException {Expression tmp;
        final List<Expression> qs = new ArrayList<Expression>();
    tmp = BinaryOperatorExpression();
qs.add(tmp);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      tmp = BinaryOperatorExpression();
qs.add(tmp);
    }
if (qs.size() == 1)
                        {if ("" != null) return qs.get(0);}
                {if ("" != null) return new Tuple(qs);}
    throw new Error("Missing return statement in function");
}

  final public Expression BinaryOperatorExpression() throws ParseException {Token t;
        Expression expr;
        List<Expression> exprs = new ArrayList<Expression>();
        List<BinaryOperatorExpression.Operator> operators = new ArrayList<BinaryOperatorExpression.Operator>();
    expr = PrimaryExpression();
exprs.add(expr);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OP_AND:
      case OP_OR:
      case OP_DEFAULT:
      case COMP_EQUAL:
      case COMP_NOT_EQUAL:
      case COMP_GREATER:
      case COMP_GREATER_EQUAL:
      case COMP_LESS:
      case COMP_LESS_EQUAL:
      case PLUS:
      case MINUS:
      case TIMES:
      case DIVIDE:
      case MODULO:
      case ASSIGN_OP:
      case UPDATE_OP:
      case PLUS_EQUAL:
      case MINUS_EQUAL:
      case TIMES_EQUAL:
      case DIVIDE_EQUAL:
      case MODULO_EQUAL:
      case DEFAULT_EQUAL:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:{
        t = jj_consume_token(TIMES);
        break;
        }
      case DIVIDE:{
        t = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        t = jj_consume_token(MODULO);
        break;
        }
      case PLUS:{
        t = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        t = jj_consume_token(MINUS);
        break;
        }
      case COMP_EQUAL:{
        t = jj_consume_token(COMP_EQUAL);
        break;
        }
      case COMP_NOT_EQUAL:{
        t = jj_consume_token(COMP_NOT_EQUAL);
        break;
        }
      case COMP_GREATER:{
        t = jj_consume_token(COMP_GREATER);
        break;
        }
      case COMP_GREATER_EQUAL:{
        t = jj_consume_token(COMP_GREATER_EQUAL);
        break;
        }
      case COMP_LESS:{
        t = jj_consume_token(COMP_LESS);
        break;
        }
      case COMP_LESS_EQUAL:{
        t = jj_consume_token(COMP_LESS_EQUAL);
        break;
        }
      case OP_AND:{
        t = jj_consume_token(OP_AND);
        break;
        }
      case OP_OR:{
        t = jj_consume_token(OP_OR);
        break;
        }
      case OP_DEFAULT:{
        t = jj_consume_token(OP_DEFAULT);
        break;
        }
      case ASSIGN_OP:{
        t = jj_consume_token(ASSIGN_OP);
        break;
        }
      case UPDATE_OP:{
        t = jj_consume_token(UPDATE_OP);
        break;
        }
      case PLUS_EQUAL:{
        t = jj_consume_token(PLUS_EQUAL);
        break;
        }
      case MINUS_EQUAL:{
        t = jj_consume_token(MINUS_EQUAL);
        break;
        }
      case TIMES_EQUAL:{
        t = jj_consume_token(TIMES_EQUAL);
        break;
        }
      case DIVIDE_EQUAL:{
        t = jj_consume_token(DIVIDE_EQUAL);
        break;
        }
      case MODULO_EQUAL:{
        t = jj_consume_token(MODULO_EQUAL);
        break;
        }
      case DEFAULT_EQUAL:{
        t = jj_consume_token(DEFAULT_EQUAL);
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
operators.add(BinaryOperatorExpression.Operator.fromImage(t.image));
      expr = PrimaryExpression();
exprs.add(expr);
    }
{if ("" != null) return BinaryOperatorExpression.buildTree(exprs, operators, version);}
    throw new Error("Missing return statement in function");
}

  final public Expression FunctionDefinition() throws ParseException {final List<String> args = new ArrayList<String>();
        Token fname;
        String tmp;
        Expression body;
    jj_consume_token(KEYWORD_DEF);
    fname = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      tmp = FunctionDefinitionParam();
args.add(tmp);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_6;
        }
        jj_consume_token(SEMICOLON);
        tmp = FunctionDefinitionParam();
args.add(tmp);
      }
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    body = Expression();
    jj_consume_token(SEMICOLON);
{if ("" != null) return new FunctionDefinition(fname.image, args, body);}
    throw new Error("Missing return statement in function");
}

  final public String FunctionDefinitionParam() throws ParseException {Token param;
        boolean isvar = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
isvar = true;
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    param = jj_consume_token(IDENTIFIER);
{if ("" != null) return (isvar ? "$" : "") + param.image;}
    throw new Error("Missing return statement in function");
}

  final public Expression PrimaryExpression() throws ParseException {Token t;
        Expression tmp;
        List<Expression> exprs = new ArrayList<Expression>();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_DEF:{
        ;
        break;
        }
      default:
        jj_la1[20] = jj_gen;
        break label_7;
      }
      tmp = FunctionDefinition();
exprs.add(tmp);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      tmp = ThisObjectAccess();
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QUESTION:{
          ;
          break;
          }
        default:
          jj_la1[21] = jj_gen;
          break label_8;
        }
        jj_consume_token(QUESTION);
tmp = new TryCatch.Question(tmp);
      }
      break;
      }
    case DOLLAR:{
      tmp = VariableAccess();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QUESTION:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_9;
        }
        jj_consume_token(QUESTION);
tmp = new TryCatch.Question(tmp);
      }
      break;
      }
    case OPEN_BRACKET:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:{
        tmp = ValueLiteral();
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        if (jj_2_1(3)) {
          tmp = StringInterpolation();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ATSIGN:{
            tmp = FormattingFilter();
            break;
            }
          case OPEN_BRACKET:{
            tmp = ArrayConstruction();
            break;
            }
          case OPEN_BRACE:{
            tmp = ObjectConstruction();
            break;
            }
          case IDENTIFIER:{
            tmp = FunctionCall();
            break;
            }
          default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QUESTION:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_10;
        }
        jj_consume_token(QUESTION);
tmp = new TryCatch.Question(tmp);
      }
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      tmp = Expression();
      jj_consume_token(CLOSE_PAR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        ;
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QUESTION:{
          ;
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_11;
        }
        jj_consume_token(QUESTION);
tmp = new TryCatch.Question(tmp);
      }
      break;
      }
    case MINUS:{
      jj_consume_token(MINUS);
      tmp = PrimaryExpression();
tmp = new NegativeExpression(tmp);
      break;
      }
    case KEYWORD_IF:{
      tmp = ConditionalExpression();
      break;
      }
    case KEYWORD_REDUCE:{
      tmp = ReduceExpression();
      break;
      }
    case RECURSION:{
      tmp = RecursionOperator();
      break;
      }
    case KEYWORD_FOREACH:{
      tmp = ForeachExpression();
      break;
      }
    case KEYWORD_TRY:{
      tmp = TryCatchExpression();
      break;
      }
    case KEYWORD_BREAK:{
      tmp = BreakExpression();
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
exprs.add(tmp);
                if (exprs.size() == 1)
                        {if ("" != null) return exprs.get(0);}
                {if ("" != null) return new SemicolonOperator(exprs);}
    throw new Error("Missing return statement in function");
}

  final public Expression RecursionOperator() throws ParseException {
    jj_consume_token(RECURSION);
{if ("" != null) return new RecursionOperator();}
    throw new Error("Missing return statement in function");
}

  final public Expression FormattingFilter() throws ParseException {Token t;
    jj_consume_token(ATSIGN);
    t = jj_consume_token(IDENTIFIER);
{if ("" != null) return new FormattingFilter(t.image, version);}
    throw new Error("Missing return statement in function");
}

  final public Expression TryCatchExpression() throws ParseException {Expression tryExpr, catchExpr = null;
    jj_consume_token(KEYWORD_TRY);
    tryExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case KEYWORD_CATCH:{
      jj_consume_token(KEYWORD_CATCH);
      catchExpr = PrimaryExpression();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
{if ("" != null) return new TryCatch(tryExpr, catchExpr);}
    throw new Error("Missing return statement in function");
}

  final public Expression BreakExpression() throws ParseException {String name;
    jj_consume_token(KEYWORD_BREAK);
    jj_consume_token(DOLLAR);
    name = IdentifierAsString();
{if ("" != null) return new BreakExpression(name);}
    throw new Error("Missing return statement in function");
}

  final public Expression ForeachExpression() throws ParseException {PatternMatcher matcher;
        Expression initExpr, updateExpr, extractExpr = null, iterExpr;
    jj_consume_token(KEYWORD_FOREACH);
    iterExpr = PrimaryExpression();
    jj_consume_token(KEYWORD_AS);
    matcher = Matcher();
    jj_consume_token(OPEN_PAR);
    initExpr = Expression();
    jj_consume_token(SEMICOLON);
    updateExpr = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      extractExpr = Expression();
      break;
      }
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_PAR);
{if ("" != null) return new ForeachExpression(matcher, initExpr, updateExpr, extractExpr, iterExpr);}
    throw new Error("Missing return statement in function");
}

  final public Expression ReduceExpression() throws ParseException {PatternMatcher matcher;
        Expression tmpIterExpr, tmpInitExpr, tmpReduceExpr;
    jj_consume_token(KEYWORD_REDUCE);
    tmpIterExpr = PrimaryExpression();
    jj_consume_token(KEYWORD_AS);
    matcher = Matcher();
    jj_consume_token(OPEN_PAR);
    tmpInitExpr = Expression();
    jj_consume_token(SEMICOLON);
    tmpReduceExpr = Expression();
    jj_consume_token(CLOSE_PAR);
{if ("" != null) return new ReduceExpression(matcher, tmpInitExpr, tmpReduceExpr, tmpIterExpr);}
    throw new Error("Missing return statement in function");
}

  final public Expression VariableAccess() throws ParseException {Token t;
        Expression tmp;
        String moduleName = null;
    jj_consume_token(DOLLAR);
    if (jj_2_2(2)) {
      // both branches starts with <IDENTIFIER> with/without module name
                      moduleName = IdentifierAsString();
      jj_consume_token(DOUBLE_COLON);
    } else {
      ;
    }
    t = jj_consume_token(IDENTIFIER);
{if ("" != null) return new VariableAccess(moduleName, t.image);}
    throw new Error("Missing return statement in function");
}

  final public Expression ConditionalExpression() throws ParseException {Expression tmpPred;
        Expression tmpExpr;
        final List<Pair<Expression, Expression>> switches = new ArrayList<Pair<Expression, Expression>>();
        final Expression otherwise;
    jj_consume_token(KEYWORD_IF);
    tmpPred = Expression();
    jj_consume_token(KEYWORD_THEN);
    tmpExpr = Expression();
switches.add(Pair.of(tmpPred, tmpExpr));
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case KEYWORD_ELIF:{
        ;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        break label_12;
      }
      jj_consume_token(KEYWORD_ELIF);
      tmpPred = Expression();
      jj_consume_token(KEYWORD_THEN);
      tmpExpr = Expression();
switches.add(Pair.of(tmpPred, tmpExpr));
    }
    jj_consume_token(KEYWORD_ELSE);
    otherwise = Expression();
    jj_consume_token(KEYWORD_END);
{if ("" != null) return new Conditional(switches, otherwise);}
    throw new Error("Missing return statement in function");
}

  final public Expression ObjectConstruction() throws ParseException {final ObjectConstruction obj = new ObjectConstruction();
    jj_consume_token(OPEN_BRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case OPEN_PAR:
    case DOLLAR:
    case ATSIGN:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:
    case IDENTIFIER:{
      ObjectField(obj);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[34] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        ObjectField(obj);
      }
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACE);
{if ("" != null) return obj;}
    throw new Error("Missing return statement in function");
}

  final public void ObjectField(final ObjectConstruction obj) throws ParseException {String name;
        Expression value = null;
        Expression key = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
      name = KeywordOrIdentifier();
obj.add(new VariableKeyFieldConstruction(name));
      break;
      }
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:
    case IDENTIFIER:{
      // {name}, {name: value}
                      name = KeywordOrIdentifier();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        value = ObjectFieldValue();
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
obj.add(new IdentifierKeyFieldConstruction(name, value));
      break;
      }
    case ATSIGN:
    case QUOTE:{
      // {"name"}, {"name": value}
                      key = StringInterpolation();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        value = ObjectFieldValue();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
obj.add(new StringKeyFieldConstruction(key, value));
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      key = Expression();
      jj_consume_token(CLOSE_PAR);
      jj_consume_token(COLON);
      value = ObjectFieldValue();
obj.add(new JsonQueryKeyFieldConstruction(key, value));
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Expression ObjectFieldName() throws ParseException {Token token;
        Expression expr;
        String keywordAsString;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OP_AND:
    case OP_OR:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:{
      keywordAsString = KeywordAsString();
expr = new StringLiteral(keywordAsString);
      break;
      }
    case ATSIGN:
    case QUOTE:{
      expr = StringInterpolation();
      break;
      }
    case IDENTIFIER:{
      token = jj_consume_token(IDENTIFIER);
expr = new StringLiteral(token.image);
      break;
      }
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      expr = Expression();
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public Expression ObjectFieldValue() throws ParseException {Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      expr = Expression();
      jj_consume_token(CLOSE_PAR);
      break;
      }
    case MINUS:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      expr = JsonQueryWithoutComma();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public Expression ArrayConstruction() throws ParseException {Expression tmp = null;
    jj_consume_token(OPEN_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      tmp = Expression();
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
if (tmp == null)
                        {if ("" != null) return new ArrayConstruction();}
                {if ("" != null) return new ArrayConstruction(tmp);}
    throw new Error("Missing return statement in function");
}

  final public Expression ValueLiteral() throws ParseException {Token token;
        String text;
        Expression tmp;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_LITERAL:{
      token = jj_consume_token(INTEGER_LITERAL);
tmp = new LongLiteral(Long.parseLong(token.image));
      break;
      }
    case FLOAT_LITERAL:{
      token = jj_consume_token(FLOAT_LITERAL);
tmp = new DoubleLiteral(Double.parseDouble(token.image));
      break;
      }
    case NULL_LITERAL:{
      jj_consume_token(NULL_LITERAL);
tmp = new NullLiteral();
      break;
      }
    case BOOLEAN_LITERAL_TRUE:{
      jj_consume_token(BOOLEAN_LITERAL_TRUE);
tmp = new BooleanLiteral(true);
      break;
      }
    case BOOLEAN_LITERAL_FALSE:{
      jj_consume_token(BOOLEAN_LITERAL_FALSE);
tmp = new BooleanLiteral(false);
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return tmp;}
    throw new Error("Missing return statement in function");
}

  final public Expression FunctionCall() throws ParseException {Expression tmp;
        final Token fname;
        final List<Expression> fargs = new ArrayList<Expression>();
        String moduleName = null;
    if (jj_2_3(2)) {
      // fname and module::fname both starts with <IDENTIFIER>
                      moduleName = IdentifierAsString();
      jj_consume_token(DOUBLE_COLON);
    } else {
      ;
    }
    fname = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN_PAR:{
      jj_consume_token(OPEN_PAR);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:
      case OPEN_PAR:
      case DOT:
      case RECURSION:
      case OPEN_BRACKET:
      case DOLLAR:
      case ATSIGN:
      case OPEN_BRACE:
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case QUOTE:
      case KEYWORD_IF:
      case KEYWORD_DEF:
      case KEYWORD_REDUCE:
      case KEYWORD_FOREACH:
      case KEYWORD_TRY:
      case KEYWORD_LABEL:
      case KEYWORD_BREAK:
      case IDENTIFIER:{
        tmp = Expression();
fargs.add(tmp);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[43] = jj_gen;
            break label_14;
          }
          jj_consume_token(SEMICOLON);
          tmp = Expression();
fargs.add(tmp);
        }
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      jj_consume_token(CLOSE_PAR);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
{if ("" != null) return new FunctionCall(moduleName, fname.image, fargs, version);}
    throw new Error("Missing return statement in function");
}

  final public Expression FieldAccessor(Expression obj) throws ParseException {
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENTIFIER_AFTER_DOT:{
          obj = IdentifierFieldAccessor(obj);
          break;
          }
        case ATSIGN:
        case QUOTE:{
          obj = StringFieldAccessor(obj);
          break;
          }
        default:
          jj_la1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case OPEN_BRACKET:{
        obj = BracketFieldAccessor(obj);
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        ;
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        break label_15;
      }
    }
{if ("" != null) return obj;}
    throw new Error("Missing return statement in function");
}

  final public Expression ThisObjectAccess() throws ParseException {Token identifier;
        boolean permissive;
        Expression tmp = new ThisObject();
    jj_consume_token(DOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER_AFTER_DOT:
    case OPEN_BRACKET:
    case ATSIGN:
    case QUOTE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENTIFIER_AFTER_DOT:{
        tmp = IdentifierFieldAccessor(tmp);
        break;
        }
      case ATSIGN:
      case QUOTE:{
        tmp = StringFieldAccessor(tmp);
        break;
        }
      case OPEN_BRACKET:{
        tmp = BracketFieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case OPEN_BRACKET:{
        tmp = FieldAccessor(tmp);
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
{if ("" != null) return tmp;}
    throw new Error("Missing return statement in function");
}

  final public Expression IdentifierFieldAccessor(Expression obj) throws ParseException {Token identifier;
        boolean permissive = false;
    identifier = jj_consume_token(IDENTIFIER_AFTER_DOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
{if ("" != null) return new IdentifierFieldAccess(obj, identifier.image, permissive);}
    throw new Error("Missing return statement in function");
}

  final public Expression StringFieldAccessor(Expression obj) throws ParseException {Expression fieldName;
        boolean permissive = false;
    fieldName = StringInterpolation();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      ;
    }
{if ("" != null) return new StringFieldAccess(obj, fieldName, permissive);}
    throw new Error("Missing return statement in function");
}

  final public Expression BracketFieldAccessor(Expression obj) throws ParseException {Expression begin = null, end = null;
        boolean rangeAccess = true;
        boolean permissive = false;
    jj_consume_token(OPEN_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case OPEN_PAR:
    case DOT:
    case RECURSION:
    case OPEN_BRACKET:
    case DOLLAR:
    case ATSIGN:
    case OPEN_BRACE:
    case COLON:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case INTEGER_LITERAL:
    case FLOAT_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:
      case OPEN_PAR:
      case DOT:
      case RECURSION:
      case OPEN_BRACKET:
      case DOLLAR:
      case ATSIGN:
      case OPEN_BRACE:
      case BOOLEAN_LITERAL_TRUE:
      case BOOLEAN_LITERAL_FALSE:
      case NULL_LITERAL:
      case INTEGER_LITERAL:
      case FLOAT_LITERAL:
      case QUOTE:
      case KEYWORD_IF:
      case KEYWORD_DEF:
      case KEYWORD_REDUCE:
      case KEYWORD_FOREACH:
      case KEYWORD_TRY:
      case KEYWORD_LABEL:
      case KEYWORD_BREAK:
      case IDENTIFIER:{
        begin = Expression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case MINUS:
          case OPEN_PAR:
          case DOT:
          case RECURSION:
          case OPEN_BRACKET:
          case DOLLAR:
          case ATSIGN:
          case OPEN_BRACE:
          case BOOLEAN_LITERAL_TRUE:
          case BOOLEAN_LITERAL_FALSE:
          case NULL_LITERAL:
          case INTEGER_LITERAL:
          case FLOAT_LITERAL:
          case QUOTE:
          case KEYWORD_IF:
          case KEYWORD_DEF:
          case KEYWORD_REDUCE:
          case KEYWORD_FOREACH:
          case KEYWORD_TRY:
          case KEYWORD_LABEL:
          case KEYWORD_BREAK:
          case IDENTIFIER:{
            end = Expression();
            break;
            }
          default:
            jj_la1[54] = jj_gen;

          }
          break;
          }
        default:
          jj_la1[55] = jj_gen;
rangeAccess = false;
        }
        break;
        }
      case COLON:{
        jj_consume_token(COLON);
        end = Expression();
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(CLOSE_BRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION:{
      jj_consume_token(QUESTION);
permissive = true;
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
if (rangeAccess) {
                        if (begin == null && end == null)
                                {if ("" != null) return new BracketExtractFieldAccess(obj, permissive);}
                        {if ("" != null) return new BracketFieldAccess(obj, begin, end, permissive);}
                } else {
                        {if ("" != null) return new BracketFieldAccess(obj, begin, permissive);}
                }
    throw new Error("Missing return statement in function");
}

  final public Expression StringInterpolation() throws ParseException {Token t;
        final StringBuilder builder = new StringBuilder();
        final List<Pair<Integer, Expression>> interpolations = new ArrayList<Pair<Integer, Expression>>();
        Expression tmp;
        Expression formatter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATSIGN:{
      formatter = FormattingFilter();
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    jj_consume_token(QUOTE);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VISIBLE_CHAR:
      case ESCAPE_CHAR:
      case OPEN_INTERP:
      case CODEPOINT_CHAR:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VISIBLE_CHAR:{
        t = jj_consume_token(VISIBLE_CHAR);
builder.append(t.image);
        break;
        }
      case ESCAPE_CHAR:{
        t = jj_consume_token(ESCAPE_CHAR);
if (t.image.charAt(0) != '\\')
                                {if (true) throw new IllegalStateException("???");}
                        final char c = t.image.charAt(1);
                        switch (c)
                        {
                                case '\"': builder.append('\"'); break;
                                case '\\': builder.append('\\'); break;
                                case 'b': builder.append((char) 0x08); break;
                                case 'f': builder.append((char) 0x0c); break;
                                case 'r': builder.append((char) 0x0d); break;
                                case 't': builder.append((char) 0x09); break;
                                case 'n': builder.append((char) 0x0a); break;
                                case '/': builder.append('/'); break;
                                default: {
                                        {if (true) throw new IllegalStateException("Unexpected escape char: " + c);}
                                }
                        }
        break;
        }
      case CODEPOINT_CHAR:{
        t = jj_consume_token(CODEPOINT_CHAR);
if (t.image.charAt(0) != '\\' || t.image.charAt(1) != 'u')
                                {if (true) throw new IllegalStateException("???");}
                        builder.appendCodePoint(Integer.parseInt(t.image.substring(2), 16));
        break;
        }
      case OPEN_INTERP:{
        jj_consume_token(OPEN_INTERP);
        tmp = Expression();
        jj_consume_token(CLOSE_PAR);
interpolations.add(Pair.of(builder.length(), tmp));
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(ENDQUOTE);
if (interpolations.isEmpty() && formatter == null) {
                        {if ("" != null) return new StringLiteral(builder.toString());}
                } else {
                        {if ("" != null) return new StringInterpolation(builder.toString(), interpolations, formatter);}
                }
    throw new Error("Missing return statement in function");
}

  final public PatternMatcher Matcher() throws ParseException {PatternMatcher matcher;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      matcher = ValueMatcher();
      break;
      }
    case OPEN_BRACKET:{
      matcher = ArrayMatcher();
      break;
      }
    case OPEN_BRACE:{
      matcher = ObjectMatcher();
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return matcher;}
    throw new Error("Missing return statement in function");
}

  final public PatternMatcher ArrayMatcher() throws ParseException {PatternMatcher matcher;
        final List<PatternMatcher> matchers = new ArrayList<PatternMatcher>();
    jj_consume_token(OPEN_BRACKET);
    matcher = Matcher();
matchers.add(matcher);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      matcher = Matcher();
matchers.add(matcher);
    }
    jj_consume_token(CLOSE_BRACKET);
{if ("" != null) return new ArrayMatcher(matchers);}
    throw new Error("Missing return statement in function");
}

  final public PatternMatcher ObjectMatcher() throws ParseException {ObjectMatcher.FieldMatcher fmatcher;
        final List<ObjectMatcher.FieldMatcher> matchers = new ArrayList<ObjectMatcher.FieldMatcher>();
    jj_consume_token(OPEN_BRACE);
    fmatcher = ObjectMatcherField();
matchers.add(fmatcher);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      fmatcher = ObjectMatcherField();
matchers.add(fmatcher);
    }
    jj_consume_token(CLOSE_BRACE);
{if ("" != null) return new ObjectMatcher(matchers);}
    throw new Error("Missing return statement in function");
}

  final public ObjectMatcher.FieldMatcher ObjectMatcherField() throws ParseException {Expression nameExpr = null;
        String name;
        PatternMatcher matcher = null;
        boolean dollar = false; // true if {$x} or {$x:...}; false if {x:...}

    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
dollar = true;
      name = KeywordOrIdentifier();
nameExpr = new StringLiteral(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        matcher = Matcher();
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        ;
      }
      break;
      }
    case OP_AND:
    case OP_OR:
    case OPEN_PAR:
    case ATSIGN:
    case BOOLEAN_LITERAL_TRUE:
    case BOOLEAN_LITERAL_FALSE:
    case NULL_LITERAL:
    case QUOTE:
    case KEYWORD_IF:
    case KEYWORD_THEN:
    case KEYWORD_ELIF:
    case KEYWORD_ELSE:
    case KEYWORD_END:
    case KEYWORD_AS:
    case KEYWORD_DEF:
    case KEYWORD_REDUCE:
    case KEYWORD_FOREACH:
    case KEYWORD_TRY:
    case KEYWORD_CATCH:
    case KEYWORD_LABEL:
    case KEYWORD_BREAK:
    case KEYWORD_IMPORT:
    case KEYWORD_INCLUDE:
    case KEYWORD_MODULE:
    case IDENTIFIER:{
      nameExpr = ObjectFieldName();
      jj_consume_token(COLON);
      matcher = Matcher();
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new ObjectMatcher.FieldMatcher(dollar, nameExpr, matcher);}
    throw new Error("Missing return statement in function");
}

  final public PatternMatcher ValueMatcher() throws ParseException {Token token;
    jj_consume_token(DOLLAR);
    token = jj_consume_token(IDENTIFIER);
{if ("" != null) return new ValueMatcher(token.image);}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_3R_ValueLiteral_932_17_67()
 {
    if (jj_scan_token(NULL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1122_17_26()
 {
    if (jj_scan_token(CODEPOINT_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_ValueLiteral_929_17_66()
 {
    if (jj_scan_token(FLOAT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Expression_367_9_28()
 {
    if (jj_3R_PipeComponent_422_9_29()) return true;
    return false;
  }

  private boolean jj_3R_ValueLiteral_926_17_65()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_ReduceExpression_744_9_56()
 {
    if (jj_scan_token(KEYWORD_REDUCE)) return true;
    return false;
  }

  private boolean jj_3R_FunctionDefinition_554_9_47()
 {
    if (jj_scan_token(KEYWORD_DEF)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_637_17_39()
 {
    if (jj_scan_token(OPEN_PAR)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_627_25_54()
 {
    if (jj_3R_FunctionCall_952_9_64()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_625_25_53()
 {
    if (jj_3R_ObjectConstruction_806_9_63()) return true;
    return false;
  }

  private boolean jj_3R_ValueLiteral_925_9_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ValueLiteral_926_17_65()) {
    jj_scanpos = xsp;
    if (jj_3R_ValueLiteral_929_17_66()) {
    jj_scanpos = xsp;
    if (jj_3R_ValueLiteral_932_17_67()) {
    jj_scanpos = xsp;
    if (jj_3R_ValueLiteral_935_17_68()) {
    jj_scanpos = xsp;
    if (jj_3R_ValueLiteral_938_17_69()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_623_25_52()
 {
    if (jj_3R_ArrayConstruction_906_9_62()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_621_25_51()
 {
    if (jj_3R_FormattingFilter_685_9_23()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_StringInterpolation_1093_9_19()) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1101_17_25()
 {
    if (jj_scan_token(ESCAPE_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_IdentifierAsString_252_9_20()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_615_25_50()
 {
    if (jj_3R_ValueLiteral_925_9_61()) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1098_17_24()
 {
    if (jj_scan_token(VISIBLE_CHAR)) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1098_17_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringInterpolation_1098_17_24()) {
    jj_scanpos = xsp;
    if (jj_3R_StringInterpolation_1101_17_25()) {
    jj_scanpos = xsp;
    if (jj_3R_StringInterpolation_1122_17_26()) {
    jj_scanpos = xsp;
    if (jj_3R_StringInterpolation_1129_17_27()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_StringInterpolation_1094_17_21()
 {
    if (jj_3R_FormattingFilter_685_9_23()) return true;
    return false;
  }

  private boolean jj_3R_ForeachExpression_721_9_58()
 {
    if (jj_scan_token(KEYWORD_FOREACH)) return true;
    return false;
  }

  private boolean jj_3R_PipeComponent_428_17_31()
 {
    if (jj_3R_TupleExpression_469_9_32()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_614_17_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_615_25_50()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_621_25_51()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_623_25_52()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_625_25_53()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_627_25_54()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ArrayConstruction_906_9_62()
 {
    if (jj_scan_token(OPEN_BRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PipeComponent_423_17_30()
 {
    if (jj_scan_token(KEYWORD_LABEL)) return true;
    return false;
  }

  private boolean jj_3R_ThisObjectAccess_998_9_48()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1093_9_19()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_StringInterpolation_1094_17_21()) jj_scanpos = xsp;
    if (jj_scan_token(QUOTE)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_StringInterpolation_1098_17_22()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDQUOTE)) return true;
    return false;
  }

  private boolean jj_3R_ObjectConstruction_806_9_63()
 {
    if (jj_scan_token(OPEN_BRACE)) return true;
    return false;
  }

  private boolean jj_3R_BreakExpression_709_9_60()
 {
    if (jj_scan_token(KEYWORD_BREAK)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_605_17_37()
 {
    if (jj_3R_VariableAccess_763_9_49()) return true;
    return false;
  }

  private boolean jj_3R_PipeComponent_422_9_29()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PipeComponent_423_17_30()) {
    jj_scanpos = xsp;
    if (jj_3R_PipeComponent_428_17_31()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_599_17_36()
 {
    if (jj_3R_ThisObjectAccess_998_9_48()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_595_17_35()
 {
    if (jj_3R_FunctionDefinition_554_9_47()) return true;
    return false;
  }

  private boolean jj_3R_TryCatchExpression_695_9_59()
 {
    if (jj_scan_token(KEYWORD_TRY)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_594_9_34()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_595_17_35()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_599_17_36()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_605_17_37()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_614_17_38()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_637_17_39()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_648_17_40()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_652_17_41()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_654_17_42()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_656_17_43()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_658_17_44()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_660_17_45()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_662_17_46()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ConditionalExpression_781_9_55()
 {
    if (jj_scan_token(KEYWORD_IF)) return true;
    return false;
  }

  private boolean jj_3R_FormattingFilter_685_9_23()
 {
    if (jj_scan_token(ATSIGN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_BinaryOperatorExpression_491_9_33()
 {
    if (jj_3R_PrimaryExpression_594_9_34()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_IdentifierAsString_252_9_20()) return true;
    if (jj_scan_token(DOUBLE_COLON)) return true;
    return false;
  }

  private boolean jj_3R_RecursionOperator_676_9_57()
 {
    if (jj_scan_token(RECURSION)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_IdentifierAsString_252_9_20()) return true;
    if (jj_scan_token(DOUBLE_COLON)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_662_17_46()
 {
    if (jj_3R_BreakExpression_709_9_60()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_660_17_45()
 {
    if (jj_3R_TryCatchExpression_695_9_59()) return true;
    return false;
  }

  private boolean jj_3R_VariableAccess_763_9_49()
 {
    if (jj_scan_token(DOLLAR)) return true;
    return false;
  }

  private boolean jj_3R_FunctionCall_952_9_64()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_658_17_44()
 {
    if (jj_3R_ForeachExpression_721_9_58()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_656_17_43()
 {
    if (jj_3R_RecursionOperator_676_9_57()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_654_17_42()
 {
    if (jj_3R_ReduceExpression_744_9_56()) return true;
    return false;
  }

  private boolean jj_3R_StringInterpolation_1129_17_27()
 {
    if (jj_scan_token(OPEN_INTERP)) return true;
    if (jj_3R_Expression_367_9_28()) return true;
    return false;
  }

  private boolean jj_3R_ValueLiteral_938_17_69()
 {
    if (jj_scan_token(BOOLEAN_LITERAL_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_652_17_41()
 {
    if (jj_3R_ConditionalExpression_781_9_55()) return true;
    return false;
  }

  private boolean jj_3R_TupleExpression_469_9_32()
 {
    if (jj_3R_BinaryOperatorExpression_491_9_33()) return true;
    return false;
  }

  private boolean jj_3R_ValueLiteral_935_17_68()
 {
    if (jj_scan_token(BOOLEAN_LITERAL_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_648_17_40()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ExpressionParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[67];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x18,0x18,0x0,0x92002000,0x92002000,0x0,0x0,0x0,0x0,0x0,0x0,0x92002000,0x0,0x92002000,0x0,0x1fffff8,0x1fffff8,0x8000000,0x2000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x10000000,0x0,0x92002000,0x0,0x8000000,0x0,0x0,0x2000018,0x0,0x0,0x2000018,0x2000018,0x92002000,0x92002000,0x0,0x8000000,0x92002000,0x2000000,0x20000000,0x10000000,0x10000000,0x20000000,0x10000000,0x20000000,0x0,0x0,0x92002000,0x0,0x92002000,0x92002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000018,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0xff003800,0xff003800,0x8,0xc102f869,0xc102f869,0x0,0x0,0x0,0x10,0x10,0x20000000,0xc102f869,0x20000000,0xc102f869,0x400,0x0,0x0,0x0,0x0,0x8,0x40000000,0x4,0x1,0x4,0xf800,0x61,0x1,0x4,0x1,0x4,0x8102f869,0x0,0x0,0x4000000,0x400,0xff023828,0x200,0x200,0xff023828,0xff023820,0xc102f869,0xc102f869,0xf800,0x0,0xc102f869,0x0,0x20020,0x1,0x1,0x20021,0x1,0x20021,0x4,0x4,0xc102f869,0x200,0xc102fa69,0xc102fa69,0x4,0x20,0xe80000,0xe80000,0x49,0x400,0x400,0x200,0xff023828,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0xff,0x1ff,0x100,0x11b,0x11b,0x80,0x60,0x60,0x0,0x0,0x0,0x11b,0x0,0x11b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x113,0x4,0x0,0x0,0x0,0x1ff,0x0,0x0,0x1ff,0x1ff,0x11b,0x11b,0x0,0x0,0x11b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x11b,0x0,0x11b,0x11b,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1ff,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[3];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public ExpressionParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ExpressionParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new ExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ExpressionParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ExpressionParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionParser(ExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ExpressionParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 67; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[75];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 67; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 75; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 3; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

        }
