/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.extra.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.extra.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"strftime/1", "strftime/2"})
@AutoService(value={Function.class})
public class StrFTimeFunction
implements Function {
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("strptime", in, JsonNodeType.NUMBER);
        try {
            args.get(0).apply(scope, in, fmt -> {
                if (!fmt.isTextual()) {
                    throw new JsonQueryTypeException("Illegal argument type: %s", new Object[]{fmt.getNodeType()});
                }
                SimpleDateFormat sdf = new SimpleDateFormat(fmt.asText());
                if (args.size() == 2) {
                    ((Expression)args.get(1)).apply(scope, in, tz -> {
                        if (!tz.isTextual()) {
                            throw new JsonQueryTypeException("Timezone must be a string");
                        }
                        sdf.setTimeZone(TimeZone.getTimeZone(tz.asText()));
                        output.emit((JsonNode)new TextNode(sdf.format((long)in.asDouble())), null);
                    });
                } else {
                    output.emit((JsonNode)new TextNode(sdf.format((long)in.asDouble())), null);
                }
            });
        }
        catch (Exception e) {
            throw new JsonQueryException((Throwable)e);
        }
    }
}

