/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.rule.basic;

import java.util.List;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTFunctionNode;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.ecmascript.rule.AbstractEcmascriptRule;

public class ConsistentReturnRule
extends AbstractEcmascriptRule {
    public ConsistentReturnRule() {
        this.addRuleChainVisit(ASTFunctionNode.class);
    }

    @Override
    public Object visit(ASTFunctionNode functionNode, Object data) {
        List returnStatements = functionNode.findDescendantsOfType(ASTReturnStatement.class);
        Boolean hasResult = null;
        for (ASTReturnStatement returnStatement : returnStatements) {
            if (functionNode != returnStatement.getFirstParentOfType(ASTFunctionNode.class)) continue;
            if (hasResult == null) {
                hasResult = returnStatement.hasResult();
                continue;
            }
            if (hasResult.booleanValue() == returnStatement.hasResult()) continue;
            this.addViolation(data, functionNode);
            break;
        }
        return data;
    }
}

