/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCharLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTNumericLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import org.apache.commons.lang3.mutable.MutableInt;

public class InsufficientStringBufferDeclarationRule
extends AbstractJavaRulechainRule {
    private static final int DEFAULT_BUFFER_SIZE = 16;

    public InsufficientStringBufferDeclarationRule() {
        super(ASTVariableId.class, new Class[0]);
    }

    public Object visit(ASTVariableId node, Object data) {
        if (!TypeTestUtil.isA(StringBuilder.class, (TypeNode)node) && !TypeTestUtil.isA(StringBuffer.class, (TypeNode)node)) {
            return data;
        }
        State state = this.getConstructorCapacity(node, node.getInitializer());
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : node.getLocalUsages()) {
            if (usage.getParent() instanceof ASTMethodCall) {
                GenericNode parent = usage.getParent();
                while (parent instanceof ASTMethodCall) {
                    ASTMethodCall methodCall = (ASTMethodCall)parent;
                    this.processMethodCall(state, methodCall);
                    parent = parent.getParent();
                }
                continue;
            }
            if (!(usage.getParent() instanceof ASTAssignmentExpression)) continue;
            ASTAssignmentExpression assignment = (ASTAssignmentExpression)usage.getParent();
            State newState = this.getConstructorCapacity(node, assignment.getRightOperand());
            if (newState.rootNode != null) {
                if (state.isInsufficient()) {
                    this.asCtx(data).addViolation((Node)state.rootNode, (Object[])state.getParamsForViolation());
                }
                state = newState;
                continue;
            }
            state.addAnticipatedLength(newState.anticipatedLength);
        }
        if (state.isInsufficient()) {
            this.asCtx(data).addViolation((Node)state.rootNode, (Object[])state.getParamsForViolation());
        }
        return data;
    }

    private void processMethodCall(State state, ASTMethodCall methodCall) {
        int newCapacity;
        if ("append".equals(methodCall.getMethodName())) {
            int counter = 0;
            HashSet literals = new HashSet();
            literals.addAll(methodCall.getArguments().descendants(ASTLiteral.class).filter(n -> n.ancestors(ASTMethodCall.class).first() == methodCall).toList());
            for (ASTLiteral literal : literals) {
                if (literal instanceof ASTStringLiteral) {
                    counter += ((ASTStringLiteral)literal).length();
                    continue;
                }
                if (literal instanceof ASTNumericLiteral) {
                    if (literal.getParent() instanceof ASTCastExpression && TypeTestUtil.isA(Character.TYPE, (TypeNode)((ASTCastExpression)literal.getParent()))) {
                        ++counter;
                        continue;
                    }
                    counter += String.valueOf(((ASTNumericLiteral)literal).getConstValue()).length();
                    continue;
                }
                if (!(literal instanceof ASTCharLiteral)) continue;
                ++counter;
            }
            ASTIfStatement ifStatement = (ASTIfStatement)methodCall.ancestors(ASTIfStatement.class).first();
            ASTSwitchStatement switchStatement = (ASTSwitchStatement)methodCall.ancestors(ASTSwitchStatement.class).first();
            if (ifStatement != null) {
                if (ifStatement.getThenBranch().descendants().any(n -> n == methodCall)) {
                    state.addBranch((Node)ifStatement.getThenBranch(), counter);
                } else if (ifStatement.getElseBranch() != null) {
                    state.addBranch((Node)ifStatement.getElseBranch(), counter);
                }
            } else if (switchStatement != null) {
                state.addBranch(methodCall.ancestors(ASTSwitchBranch.class).first(), counter);
            } else {
                state.addAnticipatedLength(counter);
            }
        } else if ("setLength".equals(methodCall.getMethodName())) {
            int newLength = this.calculateExpression((ASTExpression)methodCall.getArguments().get(0));
            if (state.capacity != -1 && newLength > state.capacity) {
                state.capacity = newLength;
                state.rootNode = methodCall;
            }
            state.anticipatedLength = newLength;
        } else if ("ensureCapacity".equals(methodCall.getMethodName()) && (newCapacity = this.calculateExpression((ASTExpression)methodCall.getArguments().get(0))) > state.capacity) {
            state.capacity = newCapacity;
            state.rootNode = methodCall;
        }
    }

    private State getConstructorCapacity(ASTVariableId variable, ASTExpression node) {
        State state = new State(variable, null, -1, 0);
        ASTExpression possibleConstructorCall = node;
        JavaNode child = node;
        while (child instanceof ASTMethodCall) {
            this.processMethodCall(state, (ASTMethodCall)child);
            child = (JavaNode)child.getFirstChild();
        }
        possibleConstructorCall = child;
        if (!(possibleConstructorCall instanceof ASTConstructorCall)) {
            return state;
        }
        ASTConstructorCall constructorCall = (ASTConstructorCall)possibleConstructorCall;
        if (constructorCall.getArguments().size() == 1) {
            ASTExpression argument = (ASTExpression)constructorCall.getArguments().get(0);
            if (argument instanceof ASTStringLiteral) {
                int stringLength = ((ASTStringLiteral)argument).length();
                return new State(variable, constructorCall, 16 + stringLength, stringLength + state.anticipatedLength);
            }
            return new State(variable, constructorCall, this.calculateExpression(argument), state.anticipatedLength);
        }
        return new State(variable, constructorCall, 16, state.anticipatedLength);
    }

    private int calculateExpression(ASTExpression expression) {
        MutableInt result = new MutableInt(-1);
        class ExpressionVisitor
        extends JavaVisitorBase<MutableInt, Void> {
            ExpressionVisitor() {
            }

            @Override
            public Void visit(ASTInfixExpression node, MutableInt data) {
                MutableInt temp = new MutableInt(-1);
                if (BinaryOp.ADD.equals(node.getOperator())) {
                    data.setValue(0);
                    node.getLeftOperand().acceptVisitor(this, temp);
                    data.add((Number)temp.getValue());
                    node.getRightOperand().acceptVisitor(this, temp);
                    data.add((Number)temp.getValue());
                } else if (BinaryOp.MUL.equals(node.getOperator())) {
                    node.getLeftOperand().acceptVisitor(this, temp);
                    data.setValue((Number)temp.getValue());
                    node.getRightOperand().acceptVisitor(this, temp);
                    data.setValue(data.getValue() * temp.getValue());
                }
                return null;
            }

            @Override
            public Void visit(ASTNumericLiteral node, MutableInt data) {
                data.setValue(node.getValueAsInt());
                return null;
            }
        }
        expression.acceptVisitor(new ExpressionVisitor(), result);
        return result.getValue();
    }

    private static class State {
        ASTVariableId variable;
        TypeNode rootNode;
        int capacity;
        int anticipatedLength;
        Map<Node, Map<Node, Integer>> branches = new HashMap<Node, Map<Node, Integer>>();

        State(ASTVariableId variable, TypeNode rootNode, int capacity, int anticipatedLength) {
            this.variable = variable;
            this.rootNode = rootNode;
            this.capacity = capacity;
            this.anticipatedLength = anticipatedLength;
        }

        public void addAnticipatedLength(int length) {
            this.anticipatedLength += length;
        }

        public boolean isInsufficient() {
            this.processBranches();
            return this.capacity >= 0 && this.anticipatedLength > this.capacity;
        }

        public String[] getParamsForViolation() {
            return new String[]{this.getTypeName(this.variable), String.valueOf(this.capacity), String.valueOf(this.anticipatedLength)};
        }

        private String getTypeName(TypeNode node) {
            return node.getTypeMirror().getSymbol().getSimpleName();
        }

        public void addBranch(Node node, int counter) {
            Node parent = node.ancestors(ASTIfStatement.class).last();
            if (parent == null) {
                parent = node.ancestors(ASTSwitchStatement.class).last();
            }
            if (parent == null) {
                return;
            }
            this.branches.putIfAbsent(parent, new HashMap());
            Map<Node, Integer> blocks = this.branches.get(parent);
            if (!blocks.containsKey(node)) {
                blocks.put(node, counter);
            } else {
                blocks.put(node, blocks.get(node) + counter);
            }
        }

        private void processBranches() {
            for (Map<Node, Integer> blocks : this.branches.values()) {
                int counter = 0;
                for (Integer i : blocks.values()) {
                    counter = Math.max(counter, i);
                }
                this.addAnticipatedLength(counter);
            }
            this.branches.clear();
        }

        public String toString() {
            return "State[capacity=" + this.capacity + ",anticipatedLength=" + this.anticipatedLength + "]";
        }
    }
}

