/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class LawOfDemeterRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Integer> TRUST_RADIUS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"trustRadius").desc("Maximum degree of trusted data. The default of 1 is the most restrictive.")).require(NumericConstraints.positive())).defaultValue((Object)1)).build();
    private static final String FIELD_ACCESS_ON_FOREIGN_VALUE = "Access to field `{0}` on foreign value `{1}` (degree {2})";
    private static final String METHOD_CALL_ON_FOREIGN_VALUE = "Call to `{0}` on foreign value `{1}` (degree {2})";
    private final Map<ASTExpression, Integer> degreeCache = new LinkedHashMap<ASTExpression, Integer>();
    private static final int TRUSTED = 0;
    private static final int ACCESSIBLE = 1;

    public LawOfDemeterRule() {
        this.definePropertyDescriptor(TRUST_RADIUS);
    }

    @Override
    public void apply(Node target, RuleContext ctx) {
        this.degreeCache.clear();
        ((ASTCompilationUnit)target).descendants().crossFindBoundaries().forEach(it -> {
            if (it instanceof ASTMethodCall) {
                this.visit((ASTMethodCall)it, (Object)ctx);
            } else if (it instanceof ASTFieldAccess) {
                this.visit((ASTFieldAccess)it, (Object)ctx);
            }
        });
        this.degreeCache.clear();
    }

    private boolean isReportedDegree(int degree) {
        return degree == (Integer)this.getProperty(TRUST_RADIUS) + 1;
    }

    public Object visit(ASTFieldAccess node, Object data) {
        if (this.shouldReport(node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, FIELD_ACCESS_ON_FOREIGN_VALUE, new Object[]{node.getName(), PrettyPrintingUtil.prettyPrint(node.getQualifier()), this.foreignDegree(node.getQualifier())});
        }
        return null;
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (this.shouldReport(node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, METHOD_CALL_ON_FOREIGN_VALUE, new Object[]{node.getMethodName(), PrettyPrintingUtil.prettyPrint(node.getQualifier()), this.foreignDegree(node.getQualifier())});
        }
        return null;
    }

    private boolean shouldReport(QualifiableExpression expr) {
        ASTExpression qualifier = expr.getQualifier();
        if (qualifier == null) {
            return false;
        }
        int degree = this.foreignDegree(expr);
        if (this.isReportedDegree(degree) && this.isUsedAsGetter(expr)) {
            if (expr.getParent() instanceof ASTVariableDeclarator) {
                return this.isAllowedStore(((ASTVariableDeclarator)expr.getParent()).getVarId());
            }
            return true;
        }
        if (qualifier instanceof ASTVariableAccess && this.isReportedDegree(this.foreignDegree(qualifier))) {
            JVariableSymbol sym = ((ASTVariableAccess)qualifier).getReferencedSym();
            return sym != null && !this.isAllowedStore((ASTVariableId)sym.tryGetNode());
        }
        return false;
    }

    private boolean isAllowedStore(ASTVariableId varId) {
        return varId != null && varId.getLocalUsages().stream().noneMatch(this::escapesMethod);
    }

    private int foreignDegree(@Nullable ASTExpression expr) {
        if (expr == null) {
            return 0;
        }
        Integer cachedValue = this.degreeCache.get(expr);
        if (cachedValue == null) {
            this.degreeCache.put(expr, -1);
            int computed = this.foreignDegreeImpl(expr);
            this.degreeCache.put(expr, computed);
            return computed;
        }
        if (cachedValue == -1) {
            return cachedValue;
        }
        return cachedValue;
    }

    private int foreignDegreeImpl(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            return this.methodCallDegree(call);
        }
        if (expr instanceof ASTFieldAccess) {
            ASTFieldAccess access = (ASTFieldAccess)expr;
            return this.fieldAccessDegree(access);
        }
        if (expr instanceof ASTVariableAccess) {
            ASTVariableAccess access = (ASTVariableAccess)expr;
            return this.variableDegree(access);
        }
        if (expr instanceof ASTArrayAccess) {
            return this.foreignDegree(((ASTArrayAccess)expr).getQualifier());
        }
        if (expr instanceof ASTConstructorCall) {
            return 1;
        }
        if (expr instanceof ASTTypeExpression || JavaAstUtils.isThisOrSuper(expr)) {
            return 0;
        }
        return 1;
    }

    private int methodCallDegree(ASTMethodCall call) {
        if (call.getOverloadSelectionInfo().isFailed() || call.getMethodType().isStatic() || JavaAstUtils.isCallOnThisInstance(call) || call.getQualifier() == null || this.isFactoryMethod(call) || this.isBuilderPattern(call.getQualifier()) || this.isPureData(call)) {
            return 1;
        }
        if (this.isPureDataContainer(call.getMethodType().getDeclaringType()) || this.isPureDataContainer(call.getTypeMirror()) || !JavaRuleUtil.isGetterCall(call) || this.isTransformationMethod(call)) {
            return this.asForeignAsQualifier(call);
        }
        return this.moreForeignThanQualifier(call);
    }

    private boolean isTransformationMethod(ASTMethodCall expr) {
        if (expr.getQualifier() == null) {
            return false;
        }
        JTypeMirror qualType = expr.getQualifier().getTypeMirror();
        JTypeMirror returnType = expr.getTypeMirror();
        return TypeOps.areRelated(qualType, returnType);
    }

    private boolean isPureData(ASTExpression expr) {
        return TypeTestUtil.isA(String.class, (TypeNode)expr) || TypeTestUtil.isA(StringBuilder.class, (TypeNode)expr) || TypeTestUtil.isA(StringBuffer.class, (TypeNode)expr) || expr.getTypeMirror().isPrimitive() || expr.getTypeMirror().isBoxedPrimitive() || JavaRuleUtil.isNullChecked(expr) || JavaAstUtils.isInfixExprWithOperator((JavaNode)expr.getParent(), BinaryOp.INSTANCEOF);
    }

    private boolean isPureDataContainer(JTypeMirror type) {
        JTypeDeclSymbol symbol = type.getSymbol();
        if (symbol instanceof JClassSymbol) {
            return "java.util".equals(symbol.getPackageName()) || TypeTestUtil.isA(Stream.class, type) || TypeTestUtil.isA(Class.class, type) || TypeTestUtil.isA(NodeList.class, type) || TypeTestUtil.isA(NamedNodeMap.class, type) || type.isArray();
        }
        return false;
    }

    private boolean escapesMethod(ASTExpression expr) {
        return expr.getParent() instanceof ASTArgumentList || expr.getParent() instanceof ASTReturnStatement || expr.getParent() instanceof ASTThrowStatement;
    }

    private boolean isUsedAsGetter(ASTExpression expr) {
        return !this.escapesMethod(expr) && !(expr.getParent() instanceof ASTExpressionStatement);
    }

    private int variableDegree(ASTVariableAccess expr) {
        DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(expr.getRoot());
        DataflowPass.ReachingDefinitionSet reaching = dataflow.getReachingDefinitions(expr);
        if (reaching.isNotFullyKnown()) {
            return expr.getReferencedSym() instanceof JFieldSymbol ? this.fieldAccessDegree(expr) : 0;
        }
        return reaching.getReaching().stream().mapToInt(this::foreignDegree).max().orElse(0);
    }

    private int fieldAccessDegree(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
        if (JavaAstUtils.isRefToFieldOfThisClass(expr) || this.isPureData(expr)) {
            return 1;
        }
        if (JavaAstUtils.isArrayLengthFieldAccess(expr)) {
            return this.asForeignAsQualifier((ASTFieldAccess)expr);
        }
        if (expr instanceof ASTFieldAccess) {
            return this.moreForeignThanQualifier((ASTFieldAccess)expr);
        }
        return 1;
    }

    private int foreignDegree(DataflowPass.AssignmentEntry def) {
        if (def.isForeachVar()) {
            ASTForeachStatement foreach = (ASTForeachStatement)def.getVarId().ancestors(ASTForeachStatement.class).firstOrThrow();
            return this.foreignDegree(foreach.getIterableExpr());
        }
        if (def.getVarId().isFormalParameter()) {
            return 1;
        }
        return this.foreignDegree(def.getRhsAsExpression());
    }

    private boolean isBuilderPattern(ASTExpression expr) {
        return this.typeEndsWith(expr, "Builder");
    }

    private boolean isFactoryMethod(ASTMethodCall expr) {
        ASTExpression qualifier = expr.getQualifier();
        if (qualifier != null) {
            return this.typeEndsWith(qualifier, "Factory") || this.nameEndsWith(qualifier, "Factory") || this.nameIs(qualifier, "factory");
        }
        return false;
    }

    private boolean nameEndsWith(ASTExpression expr, String suffix) {
        return expr instanceof ASTAssignableExpr.ASTNamedReferenceExpr && ((ASTAssignableExpr.ASTNamedReferenceExpr)expr).getName().endsWith(suffix);
    }

    private boolean nameIs(ASTExpression expr, String name) {
        return expr instanceof ASTAssignableExpr.ASTNamedReferenceExpr && ((ASTAssignableExpr.ASTNamedReferenceExpr)expr).getName().equals(name);
    }

    private boolean typeEndsWith(ASTExpression expr, String suffix) {
        return expr != null && expr.getTypeMirror() instanceof JClassType && expr.getTypeMirror().getSymbol().getSimpleName().endsWith(suffix);
    }

    private int asForeignAsQualifier(QualifiableExpression e) {
        return this.foreignDegree(Objects.requireNonNull(e.getQualifier()));
    }

    private int moreForeignThanQualifier(QualifiableExpression e) {
        return 1 + this.foreignDegree(Objects.requireNonNull(e.getQualifier()));
    }
}

