/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.util.CollectionUtil;

public class ImmutableFieldRule
extends AbstractJavaRulechainRule {
    private static final Set<String> INVALIDATING_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.Builder", (Object[])new String[]{"lombok.Data", "lombok.Setter", "lombok.Value"});
    private static final Set<String> INVALIDATING_FIELD_ANNOT = CollectionUtil.setOf((Object)"lombok.Setter", (Object[])new String[0]);

    public ImmutableFieldRule() {
        super(ASTFieldDeclaration.class, new Class[0]);
    }

    public Object visit(ASTFieldDeclaration field, Object data) {
        ASTTypeDeclaration enclosingType = field.getEnclosingType();
        if (field.getEffectiveVisibility().isAtMost(ModifierOwner.Visibility.V_PRIVATE) && !field.getModifiers().hasAny(JModifier.VOLATILE, JModifier.STATIC, JModifier.FINAL) && !JavaAstUtils.hasAnyAnnotation(enclosingType, INVALIDATING_CLASS_ANNOT) && !JavaAstUtils.hasAnyAnnotation(field, INVALIDATING_FIELD_ANNOT)) {
            DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(field.getRoot());
            block0: for (ASTVariableId varId : field.getVarIds()) {
                boolean isBlank;
                boolean hasWrite = false;
                for (ASTAssignableExpr.ASTNamedReferenceExpr usage : varId.getLocalUsages()) {
                    if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                    hasWrite = true;
                    JavaNode enclosing = (JavaNode)usage.ancestors().map(NodeStream.asInstanceOf(ASTLambdaExpression.class, (Class[])new Class[]{ASTTypeDeclaration.class, ASTConstructorDeclaration.class})).first();
                    if (enclosing instanceof ASTConstructorDeclaration && enclosing.getEnclosingType() == enclosingType) continue;
                    continue block0;
                }
                boolean bl = isBlank = varId.getInitializer() == null;
                if (!hasWrite && !isBlank) {
                    this.asCtx(data).addViolation((Node)varId, new Object[]{varId.getName()});
                    continue;
                }
                if (!hasWrite || !this.defaultValueDoesNotReachEndOfCtor(dataflow, varId)) continue;
                this.asCtx(data).addViolation((Node)varId, new Object[]{varId.getName()});
            }
        }
        return null;
    }

    private boolean defaultValueDoesNotReachEndOfCtor(DataflowPass.DataflowResult dataflow, ASTVariableId varId) {
        DataflowPass.AssignmentEntry fieldDef = DataflowPass.getFieldDefinition(varId);
        Set<DataflowPass.AssignmentEntry> killers = dataflow.getKillers(fieldDef);
        return CollectionUtil.none(killers, killer -> killer.isFieldAssignmentAtEndOfCtor() || this.isReassignedOnSomeCodePath(dataflow, (DataflowPass.AssignmentEntry)killer));
    }

    private boolean isReassignedOnSomeCodePath(DataflowPass.DataflowResult dataflow, DataflowPass.AssignmentEntry anAssignment) {
        Set<DataflowPass.AssignmentEntry> killers = dataflow.getKillers(anAssignment);
        return CollectionUtil.any(killers, killer -> !killer.isFieldAssignmentAtEndOfCtor());
    }
}

