/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.reporting.RuleContext;

public class MethodArgumentCouldBeFinalRule
extends AbstractJavaRulechainRule {
    public MethodArgumentCouldBeFinalRule() {
        super(ASTExecutableDeclaration.class, new Class[0]);
    }

    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.getBody() == null) {
            return data;
        }
        this.lookForViolation(meth, data);
        return data;
    }

    public Object visit(ASTConstructorDeclaration constructor, Object data) {
        this.lookForViolation(constructor, data);
        return data;
    }

    private void lookForViolation(ASTExecutableDeclaration node, Object data) {
        MethodArgumentCouldBeFinalRule.checkForFinal((RuleContext)data, (NodeStream<ASTVariableId>)node.getFormalParameters().toStream().map(ASTFormalParameter::getVarId));
    }

    static void checkForFinal(RuleContext ruleContext, NodeStream<ASTVariableId> variables) {
        block0: for (ASTVariableId var : variables) {
            if (var.isFinal()) continue;
            boolean used = false;
            for (ASTAssignableExpr.ASTNamedReferenceExpr usage : var.getLocalUsages()) {
                used = true;
                if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                continue block0;
            }
            if (!used) continue;
            ruleContext.addViolation((Node)var, new Object[]{var.getName()});
        }
    }
}

