/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.lang.annotation.ElementType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTArrayTypeDim;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIntersectionType;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.ASTUnionType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVoidType;
import net.sourceforge.pmd.lang.java.ast.ASTWildcardType;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.SymbolResolutionPass;
import net.sourceforge.pmd.lang.java.symbols.table.internal.JavaResolvers;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

final class TypesFromAst {
    private TypesFromAst() {
    }

    public static List<JTypeMirror> fromAst(TypeSystem ts, Substitution subst, List<ASTType> reflected) {
        return CollectionUtil.map(reflected, it -> TypesFromAst.fromAst(ts, subst, it));
    }

    public static JTypeMirror fromAst(TypeSystem ts, Substitution lexicalSubst, ASTType node) {
        if (node == null) {
            return null;
        }
        return TypesFromAst.fromAstImpl(ts, lexicalSubst, node);
    }

    private static JTypeMirror fromAstImpl(TypeSystem ts, Substitution lexicalSubst, ASTType node) {
        if (node instanceof ASTClassType) {
            return TypesFromAst.makeFromClassType(ts, (ASTClassType)node, lexicalSubst);
        }
        if (node instanceof ASTWildcardType) {
            ASTWildcardType wild = (ASTWildcardType)node;
            @Nullable JTypeMirror bound = TypesFromAst.fromAst(ts, lexicalSubst, wild.getTypeBoundNode());
            if (bound == null) {
                bound = ts.OBJECT;
            }
            return ts.wildcard(wild.isUpperBound(), bound).withAnnotations((PSet)TypesFromAst.getTypeAnnotations(node));
        }
        if (node instanceof ASTIntersectionType) {
            ArrayList<JTypeMirror> components = new ArrayList<JTypeMirror>();
            for (ASTType t : (ASTIntersectionType)node) {
                components.add(TypesFromAst.fromAst(ts, lexicalSubst, t));
            }
            try {
                return ts.glb(components);
            }
            catch (IllegalArgumentException e) {
                return ts.ERROR;
            }
        }
        if (node instanceof ASTArrayType) {
            JTypeMirror t = TypesFromAst.fromAst(ts, lexicalSubst, ((ASTArrayType)node).getElementType());
            ASTArrayDimensions dimensions = ((ASTArrayType)node).getDimensions();
            for (int i = dimensions.size() - 1; i >= 0; --i) {
                ASTArrayTypeDim dim = (ASTArrayTypeDim)dimensions.get(i);
                PSet<SymbolicValue.SymAnnot> annots = TypesFromAst.getSymbolicAnnotations(dim);
                t = ts.arrayType(t).withAnnotations((PSet)annots);
            }
            return t;
        }
        if (node instanceof ASTPrimitiveType) {
            return ts.getPrimitive(((ASTPrimitiveType)node).getKind()).withAnnotations(TypesFromAst.getTypeAnnotations(node));
        }
        if (node instanceof ASTAmbiguousName) {
            return ts.UNKNOWN;
        }
        if (node instanceof ASTUnionType) {
            return ts.lub(CollectionUtil.map(((ASTUnionType)node).getComponents(), TypeNode::getTypeMirror));
        }
        if (node instanceof ASTVoidType) {
            return ts.NO_TYPE;
        }
        throw new IllegalStateException("Illegal type " + node.getClass() + " " + node);
    }

    private static PSet<SymbolicValue.SymAnnot> getSymbolicAnnotations(Annotatable dim) {
        return SymbolResolutionPass.buildSymbolicAnnotations(dim.getDeclaredAnnotations());
    }

    private static JTypeMirror makeFromClassType(TypeSystem ts, ASTClassType node, Substitution subst) {
        if (node == null) {
            return null;
        }
        PSet<SymbolicValue.SymAnnot> typeAnnots = TypesFromAst.getTypeAnnotations(node);
        JTypeDeclSymbol reference = TypesFromAst.getReferenceEnsureResolved(node);
        if (reference instanceof JTypeParameterSymbol) {
            return subst.apply(((JTypeParameterSymbol)reference).getTypeMirror()).withAnnotations(typeAnnots);
        }
        JClassType enclosing = TypesFromAst.getEnclosing(ts, node, subst, node.getQualifier(), reference);
        ASTTypeArguments typeArguments = node.getTypeArguments();
        List boundGenerics = Collections.emptyList();
        if (typeArguments != null && !typeArguments.isDiamond()) {
            boundGenerics = new ArrayList(typeArguments.getNumChildren());
            for (ASTType t : typeArguments) {
                boundGenerics.add(TypesFromAst.fromAst(ts, subst, t));
            }
        }
        if (enclosing != null) {
            return enclosing.selectInner((JClassSymbol)reference, boundGenerics, typeAnnots);
        }
        return ts.parameterise((JClassSymbol)reference, boundGenerics).withAnnotations(typeAnnots);
    }

    private static @Nullable JClassType getEnclosing(TypeSystem ts, ASTClassType node, Substitution subst, @Nullable ASTClassType lhsType, JTypeDeclSymbol reference) {
        @Nullable JTypeMirror enclosing = TypesFromAst.makeFromClassType(ts, lhsType, subst);
        if (enclosing != null && !TypesFromAst.shouldEnclose(reference)) {
            enclosing = null;
        } else if (enclosing == null && TypesFromAst.needsEnclosing(reference)) {
            enclosing = node.getImplicitEnclosing();
            assert (enclosing != null) : "Implicit enclosing type should have been set by disambiguation, for " + node;
        }
        if (enclosing != null) {
            JClassSymbol enclosingClassAccordingToReference = reference.getEnclosingClass();
            if (enclosingClassAccordingToReference == null) {
                return null;
            }
            enclosing = enclosing.getAsSuper(enclosingClassAccordingToReference);
            assert (enclosing != null) : "We got this symbol by looking into enclosing";
            return (JClassType)enclosing;
        }
        return null;
    }

    private static boolean needsEnclosing(JTypeDeclSymbol reference) {
        return reference instanceof JClassSymbol && reference.getEnclosingClass() != null && !Modifier.isStatic(reference.getModifiers());
    }

    private static @NonNull JTypeDeclSymbol getReferenceEnsureResolved(ASTClassType node) {
        ASTExpression qualifier;
        if (node.getReferencedSym() != null) {
            return node.getReferencedSym();
        }
        if (node.getParent() instanceof ASTConstructorCall && (qualifier = ((ASTConstructorCall)node.getParent()).getQualifier()) != null) {
            JClassSymbol symbol;
            assert (node.getImplicitEnclosing() == null) : "Qualified ctor calls should be handled lazily";
            JTypeMirror qualifierType = qualifier.getTypeMirror();
            if (qualifierType instanceof JClassType) {
                JClassType enclosing = (JClassType)qualifierType;
                JClassType resolved = JavaResolvers.getMemberClassResolver(enclosing, node.getRoot().getPackageName(), node.getEnclosingType().getSymbol(), node.getSimpleName()).resolveFirst(node.getSimpleName());
                if (resolved == null) {
                    symbol = (JClassSymbol)node.getTypeSystem().UNKNOWN.getSymbol();
                } else {
                    symbol = resolved.getSymbol();
                    JClassType actualEnclosing = enclosing.getAsSuper(symbol.getEnclosingClass());
                    assert (actualEnclosing != null) : "We got this symbol by looking into enclosing";
                    node.setImplicitEnclosing(actualEnclosing);
                }
            } else {
                symbol = (JClassSymbol)node.getTypeSystem().UNKNOWN.getSymbol();
            }
            node.setSymbol(symbol);
            return symbol;
        }
        throw new IllegalStateException("Disambiguation pass should resolve everything except qualified ctor calls");
    }

    private static boolean shouldEnclose(JTypeDeclSymbol reference) {
        return !Modifier.isStatic(reference.getModifiers());
    }

    private static @Nullable Annotatable getEnclosingAnnotationGiver(JavaNode node) {
        JavaNode parent = (JavaNode)node.getParent();
        if (node.getIndexInParent() == 0 && parent instanceof ASTClassType) {
            return TypesFromAst.getEnclosingAnnotationGiver(parent);
        }
        if (node.getIndexInParent() == 0 && parent instanceof ASTArrayType) {
            return TypesFromAst.getEnclosingAnnotationGiver(parent);
        }
        if (!(parent instanceof ASTType) && parent instanceof ASTVariableDeclarator) {
            return TypesFromAst.getEnclosingAnnotationGiver(parent);
        }
        if (!(parent instanceof ASTType) && parent instanceof Annotatable) {
            return (Annotatable)parent;
        }
        return null;
    }

    private static PSet<SymbolicValue.SymAnnot> getTypeAnnotations(ASTType type) {
        PSet annotsOnType = TypesFromAst.getSymbolicAnnotations(type);
        if (type instanceof ASTClassType && ((ASTClassType)type).getQualifier() != null) {
            return annotsOnType;
        }
        Annotatable parent = TypesFromAst.getEnclosingAnnotationGiver(type);
        if (parent != null) {
            PSet<SymbolicValue.SymAnnot> parentAnnots = TypesFromAst.getSymbolicAnnotations(parent);
            for (SymbolicValue.SymAnnot parentAnnot : parentAnnots) {
                if (!parentAnnot.getAnnotationSymbol().annotationAppliesTo(ElementType.TYPE_USE)) continue;
                annotsOnType = annotsOnType.plus((Object)parentAnnot);
            }
        }
        return annotsOnType;
    }
}

