/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.FileNameRenderer;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public interface Renderer
extends PropertySource {
    public String getName();

    public void setName(String var1);

    public String getDescription();

    public String defaultFileExtension();

    public void setDescription(String var1);

    public boolean isShowSuppressedViolations();

    public void setShowSuppressedViolations(boolean var1);

    public Writer getWriter();

    public void setFileNameRenderer(FileNameRenderer var1);

    public void setWriter(Writer var1);

    public void start() throws IOException;

    public void startFileAnalysis(TextFile var1);

    public void renderFileReport(net.sourceforge.pmd.reporting.Report var1) throws IOException;

    public void end() throws IOException;

    public void flush() throws IOException;

    @Experimental
    public void setReportFile(String var1);

    default public GlobalAnalysisListener newListener() throws IOException {
        try (TimedOperation ignored = TimeTracker.startOperation((TimedOperationCategory)TimedOperationCategory.REPORTING);){
            this.start();
        }
        return new GlobalAnalysisListener(){
            final Object reportMergeLock = new Object();
            final Report.GlobalReportBuilderListener configErrorReport = new Report.GlobalReportBuilderListener();

            public void onConfigError(Report.ConfigurationError error) {
                this.configErrorReport.onConfigError(error);
            }

            public ListenerInitializer initializer() {
                return new ListenerInitializer(){

                    public void setFileNameRenderer(FileNameRenderer fileNameRenderer) {
                        Renderer.this.setFileNameRenderer(fileNameRenderer);
                    }
                };
            }

            public FileAnalysisListener startFileAnalysis(TextFile file) {
                final Renderer renderer = Renderer.this;
                renderer.startFileAnalysis(file);
                return new FileAnalysisListener(){
                    final Report.ReportBuilderListener reportBuilder = new Report.ReportBuilderListener();

                    public void onRuleViolation(RuleViolation violation) {
                        this.reportBuilder.onRuleViolation(violation);
                    }

                    public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
                        this.reportBuilder.onSuppressedRuleViolation(violation);
                    }

                    public void onError(Report.ProcessingError error) {
                        this.reportBuilder.onError(error);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws Exception {
                        this.reportBuilder.close();
                        Object object = reportMergeLock;
                        synchronized (object) {
                            try (TimedOperation ignored = TimeTracker.startOperation((TimedOperationCategory)TimedOperationCategory.REPORTING);){
                                renderer.renderFileReport((Report)this.reportBuilder.getResult());
                            }
                        }
                    }

                    public String toString() {
                        return "FileRendererListener[" + Renderer.this + "]";
                    }
                };
            }

            public void close() throws Exception {
                this.configErrorReport.close();
                Renderer.this.renderFileReport((net.sourceforge.pmd.reporting.Report)this.configErrorReport.getResult());
                try (TimedOperation ignored = TimeTracker.startOperation((TimedOperationCategory)TimedOperationCategory.REPORTING);){
                    Renderer.this.end();
                    Renderer.this.flush();
                }
            }
        };
    }

    default public void renderFileReport(Report report) throws IOException {
        net.sourceforge.pmd.reporting.Report newReport = new net.sourceforge.pmd.reporting.Report();
        newReport.merge(report);
        this.renderFileReport(newReport);
    }
}

