// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package org.stathissideris.ascii2image.core;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;

import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;

/**
 * 
 * @author Efstathios Sideris
 */
public class RenderingOptions {

	private HashMap<String, CustomShapeDefinition> customShapes;
	
	private boolean dropShadows = true;
	private boolean renderDebugLines = false;
	private boolean antialias = true;

	private int cellWidth = 10;
	private int cellHeight = 14;
	
	private float scale = 1;

	private Color backgroundColor = Color.white;

	private Font font = new Font("Dialog", Font.BOLD, 12);
	private boolean forceFontSize = false;

	/**
	 * @return
	 */
	public int getCellHeight() {
		return cellHeight;
	}

	/**
	 * @return
	 */
	public int getCellWidth() {
		return cellWidth;
	}

	/**
	 * @return
	 */
	public boolean dropShadows() {
		return dropShadows;
	}

	/**
	 * @return
	 */
	public boolean renderDebugLines() {
		return renderDebugLines;
	}

	/**
	 * @return
	 */
	public float getScale() {
		return scale;
	}

	/**
	 * @param b
	 */
	public void setDropShadows(boolean b) {
		dropShadows = b;
	}

	/**
	 * @param b
	 */
	public void setRenderDebugLines(boolean b) {
		renderDebugLines = b;
	}

	/**
	 * @param f
	 */
	public void setScale(float f) {
		scale = f;
		cellWidth *= scale;
		cellHeight *= scale;
	}

	/**
	 * @return
	 */
	public boolean performAntialias() {
		return antialias;
	}

	/**
	 * @param b
	 */
	public void setAntialias(boolean b) {
		antialias = b;
	}

	public Color getBackgroundColor() {
		return backgroundColor;
	}

	public void setBackgroundColor(Color backgroundColor) {
		this.backgroundColor = backgroundColor;
	}
	
	public boolean needsTransparency() {
		return backgroundColor.getAlpha() < 255;
	}

	public Font getFont()
	{
		return font;
	}

	public void setFont(Font font)
	{
		this.font = font;
	}

	public boolean getForceFontSize()
	{
		return forceFontSize;
	}

	public void setForceFontSize(boolean forceFontSize)
	{
		this.forceFontSize = forceFontSize;
	}
}
