// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;

public class WPrint {

	private final UTranslate position;
	private final HColor color;
	private final Display label;
	private final ISkinParam skinParam;

	public WPrint(ISkinParam skinParam, UTranslate position, HColor color, Display label) {
		this.position = position;
		this.skinParam = skinParam;
		this.label = label;
		this.color = color == null ? getBlack() : color;
	}

	private HColor getBlack() {
		return HColors.BLACK.withDark(HColors.WHITE);
	}

	private TextBlock getTextBlock() {
		final FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.sansSerif(10))
				.changeColor(color);
		return label.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
	}

	public UChange getPosition() {
		return position;
	}

	public void drawMe(UGraphic ug) {
		getTextBlock().drawU(ug);
	}

	public double getHeight(StringBounder stringBounder) {
		return getTextBlock().calculateDimension(stringBounder).getHeight();
	}

}
