// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.windowsdot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.log.Logme;

public final class WindowsDotArchive {
    // ::remove folder when __HAXE__
	// ::remove folder when __CORE__

	private static WindowsDotArchive singleton = null;

	private Boolean isThereArchive;
	private File exe;

	private WindowsDotArchive() {

	}

	public final synchronized static WindowsDotArchive getInstance() {
		if (singleton == null)
			singleton = new WindowsDotArchive();

		return singleton;
	}

	final static public String readString(InputStream is) throws IOException {
		int len = readByte(is);
		final StringBuilder sb = new StringBuilder(len);
		for (int i = 0; i < len; i++) {
			sb.append((char) readByte(is));

		}
		return sb.toString();
	}

	final static public int readNumber(InputStream is) throws IOException {
		int result = readByte(is);
		result = result * 256 + readByte(is);
		result = result * 256 + readByte(is);
		return result;
	}

	private static int readByte(InputStream is) throws IOException {
		return is.read();
	}

	private static void extract(File dir) throws IOException {
		final InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat");
		try (final BrotliInputStream is = new BrotliInputStream(raw)) {
			while (true) {
				final String name = readString(is);
				if (name.length() == 0)
					break;
				final int size = readNumber(is);
				final File fileout = new File(dir, name);

				if (fileout.exists())
					for (int i = 0; i < size; i++)
						is.read();
				else
					try (final OutputStream fos = new BufferedOutputStream(new FileOutputStream(fileout))) {
						for (int i = 0; i < size; i++)
							fos.write(is.read());
					}
			}
		}
	}

	public synchronized boolean isThereArchive() {
		if (isThereArchive == null)
			try (InputStream raw = WindowsDotArchive.class.getResourceAsStream("graphviz.dat")) {
				isThereArchive = raw != null;
			} catch (Exception e) {
				isThereArchive = false;
			}
		return isThereArchive;
	}

	public synchronized File getWindowsExeLite() {
		if (isThereArchive() == false)
			return null;

		if (exe == null) {
			final File tmp = new File(System.getProperty("java.io.tmpdir"), "_graphviz");
			try {
				tmp.mkdirs();
				extract(tmp);
			} catch (IOException e) {
				Logme.error(e);
			}
			exe = new File(tmp, "dot.exe");
		}
		return exe;
	}

}
