// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.svek;

import java.util.HashSet;
import java.util.Set;

import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UHidden;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public final class SvekResult extends AbstractTextBlock implements IEntityImage {
	// ::remove file when __CORE__

	private final DotData dotData;
	private final DotStringFactory dotStringFactory;

	public SvekResult(DotData dotData, DotStringFactory dotStringFactory) {
		this.dotData = dotData;
		this.dotStringFactory = dotStringFactory;
	}

	public void drawU(UGraphic ug) {

		for (Cluster cluster : dotStringFactory.getBibliotekon().allCluster())
			if (cluster.getGroup().isPacked() == false)
				cluster.drawU(ug, dotData.getUmlDiagramType());

		final Style style2 = getDefaultStyleDefinition(null)
				.getMergedStyle(dotData.getSkinParam().getCurrentStyleBuilder());

		final HColor borderColor = HColors
				.noGradient(style2.value(PName.LineColor).asColor(dotData.getSkinParam().getIHtmlColorSet()));

		for (SvekNode node : dotStringFactory.getBibliotekon().allNodes()) {
			final double minX = node.getMinX();
			final double minY = node.getMinY();
			final UGraphic ug2 = node.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
			final IEntityImage image = node.getImage();
			image.drawU(ug2.apply(new UTranslate(minX, minY)));
			if (image instanceof Untranslated)
				((Untranslated) image).drawUntranslated(ug.apply(borderColor), minX, minY);

		}

		final Set<String> ids = new HashSet<>();

		computeKal();

		for (SvekLine line : dotStringFactory.getBibliotekon().allLines()) {
			final UGraphic ug2 = line.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;

			final StyleBuilder currentStyleBuilder = line.getCurrentStyleBuilder();
			final Style styleLine = getDefaultStyleDefinition(line.getStereotype()).getMergedStyle(currentStyleBuilder);

			final Rainbow rainbow = Rainbow.build(styleLine, dotData.getSkinParam().getIHtmlColorSet());

			line.drawU(ug2, ids, styleLine.getStroke(), rainbow);
		}

		for (SvekNode node : dotStringFactory.getBibliotekon().allNodes())
			node.drawKals(ug);

	}

	private void computeKal() {
		for (SvekLine line : dotStringFactory.getBibliotekon().allLines())
			line.computeKal();
		for (SvekNode node : dotStringFactory.getBibliotekon().allNodes())
			node.fixOverlap();
	}

	private StyleSignature getDefaultStyleDefinition(Stereotype stereotype) {
		StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element,
				dotData.getUmlDiagramType().getStyleName(), SName.arrow);

		return result.withTOBECHANGED(stereotype);
	}

	// Duplicate SvekResult / GeneralImageBuilder
	public HColor getBackcolor() {
		final Style style = StyleSignatureBasic.of(SName.root, SName.document)
				.getMergedStyle(dotData.getSkinParam().getCurrentStyleBuilder());
		return style.value(PName.BackGroundColor).asColor(dotData.getSkinParam().getIHtmlColorSet());
	}

	private MinMax minMax;

	public XDimension2D calculateDimension(StringBounder stringBounder) {
		if (minMax == null) {
			minMax = TextBlockUtils.getMinMax(this, stringBounder, false);
			dotStringFactory.moveSvek(6 - minMax.getMinX(), 6 - minMax.getMinY());
		}
		return minMax.getDimension().delta(0, 12);
	}

	public ShapeType getShapeType() {
		return ShapeType.RECTANGLE;
	}

	public Margins getShield(StringBounder stringBounder) {
		return Margins.NONE;
	}

	public boolean isHidden() {
		return false;
	}

	public double getOverscanX(StringBounder stringBounder) {
		return 0;
	}

}
