// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.security.authentication.token;

import java.net.URLConnection;
import java.util.Map;

import net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;

/**
 * Applies from {@link SecurityAuthentication} data plain token authentication
 * access headers. This is a raw header injection with static data.
 *
 * @author Aljoscha Rittner
 */
public class TokenAuthAccessInterceptor implements SecurityAccessInterceptor {
    // ::remove folder when __HAXE__

	/**
	 * Applies from {@link SecurityAuthentication} data plain token authentication
	 * access headers.
	 * <p>
	 * Expects headers.* key value pairs to pass it directly to the connection.
	 *
	 * @param authentication the determined authentication data to authorize for the
	 *                       endpoint access
	 * @param connection     the connection to the endpoint
	 */
	@Override
	public void apply(SecurityAuthentication authentication, URLConnection connection) {

		for (Map.Entry<String, Object> header : authentication.getTokens().entrySet()) {
			if (!header.getKey().startsWith("headers.") || header.getValue() == null) {
				continue;
			}
			String key = header.getKey().substring(8);
			String value = header.getValue().toString();
			connection.setRequestProperty(key, value);
		}
	}
}
