// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.png;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

import net.sourceforge.plantuml.klimt.UAntiAliasing;

public class PngFlashcoder {
	// ::remove file when __CORE__

	private final List<BufferedImage> flashcodes;

	public PngFlashcoder(List<BufferedImage> flashcodes) {
		this.flashcodes = flashcodes;
	}

	public BufferedImage processImage(BufferedImage im, Color background) {
		if (flashcodes != null) {
			im = addImage(im, background);
		}
		return im;

	}

	private BufferedImage addImage(BufferedImage im, Color background) {

		final double width = Math.max(im.getWidth(), getWidth(flashcodes));
		final double height = im.getHeight() + getHeight(flashcodes);

		final BufferedImage newIm = new BufferedImage((int) width, (int) height, BufferedImage.TYPE_INT_RGB);
		final Graphics2D g2d = newIm.createGraphics();

		UAntiAliasing.ANTI_ALIASING_OFF.apply(g2d);
		g2d.setColor(background);
		g2d.fillRect(0, 0, newIm.getWidth(), newIm.getHeight());
		g2d.drawImage(im, null, 0, 0);
		int x = 0;
		for (BufferedImage f : flashcodes) {
			g2d.drawImage(f, null, x, (int) im.getHeight());
			x += f.getWidth();
		}
		g2d.dispose();
		return newIm;

	}

	public static int getHeight(List<BufferedImage> flashcodes) {
		int result = 0;
		for (BufferedImage im : flashcodes) {
			result = Math.max(result, im.getWidth());
		}
		return result;
	}

	public static int getWidth(List<BufferedImage> flashcodes) {
		int result = 0;
		for (BufferedImage im : flashcodes) {
			result += im.getWidth();
		}
		return result;
	}
}
