// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.help;

import java.io.IOException;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.theme.ThemeUtils;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.Log;

public class CommandHelpTheme extends SingleLineCommand2<Help> {

	public CommandHelpTheme() {
		super(getRegexConcat());
	}

	static IRegex getRegexConcat() {
		return RegexConcat.build(CommandHelpTheme.class.getName(), RegexLeaf.start(), //
				new RegexLeaf("help"), //
				RegexLeaf.spaceOneOrMore(), //
				new RegexLeaf("themes?"), RegexLeaf.end());
	}

	@Override
	protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
		diagram.add("<b>Help on themes");
		diagram.add(" ");
		diagram.add(" The possible themes are :");

		try {
			for (String theme : ThemeUtils.getAllThemeNames()) {
				diagram.add("* " + theme);
			}
		} catch (IOException e) {
			final String message = "Unexpected error listing themes: " + e.getMessage();
			Log.error(message);
			Logme.error(e);
			return CommandExecutionResult.error(message);
		}

		return CommandExecutionResult.ok();
	}
}
