// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.gitlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GNodeBuilder {
	// ::remove folder when __HAXE__

	private final List<GNode> all = new ArrayList<>();

	public GNodeBuilder(List<Commit> allCommits) {

		final Map<String, GNode> tmp = new LinkedHashMap<String, GNode>();
		for (Commit commit : allCommits) {
			final GNode node = new GNode();
			node.setComment(commit.getComment());
			node.addText(commit.getName());
			tmp.put(commit.getName(), node);
		}

		for (Commit commit : allCommits)
			for (Commit parent : commit.getAncestors())
				GNode.link(tmp.get(commit.getName()), tmp.get(parent.getName()));

		this.all.addAll(tmp.values());

		merge();

	}

	private void merge() {
		while (true) {
			boolean changed = false;
			for (Iterator<GNode> it = all.iterator(); it.hasNext();) {
				final GNode node = it.next();
				if (node.canEatTheNextOne()) {
					final GNode removed = node.eatTheNextOne();
					all.remove(removed);
					changed = true;
					break;
				}
			}
			if (changed == false)
				return;

		}
	}

	public Collection<GNode> getAllNodes() {
		return Collections.unmodifiableCollection(all);
	}

}
