// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.windowsdot.WindowsDotArchive;

class GraphvizWindowsOld extends AbstractGraphviz {
	// ::remove file when __CORE__

	static private File specificDotExe;

	@Override
	protected File specificDotExe() {
		synchronized (GraphvizWindowsOld.class) {
			if (specificDotExe == null) {
				specificDotExe = specificDotExeSlow();
			}
			if (specificDotExe == null)
				specificDotExe = WindowsDotArchive.getInstance().getWindowsExeLite();

			return specificDotExe;
		}
	}

	public boolean graphviz244onWindows() {
		try {
			return GraphvizUtils.getDotVersion() == 244;
		} catch (Exception e) {
			Logme.error(e);
			return false;
		}
	}

	private File specificDotExeSlow() {
		for (File tmp : new File("c:/").listFiles(new FileFilter() {
			public boolean accept(java.io.File pathname) {
				return pathname.isDirectory() && pathname.canRead();
			}
		})) {
			final File result = searchInDir(tmp);
			if (result != null) {
				return result;
			}
		}
		return null;
	}

	private static File searchInDir(final File dir) {
		if (dir.exists() == false || dir.isDirectory() == false) {
			return null;
		}
		final List<File> dots = new ArrayList<>();
		final File[] files = dir.listFiles(new FileFilter() {
			public boolean accept(java.io.File pathname) {
				return pathname.isDirectory() && StringUtils.goLowerCase(pathname.getName()).startsWith("graphviz");
			}
		});
		if (files == null) {
			return null;
		}
		for (File f : files) {
			final File result = new File(new File(f, "bin"), "dot.exe");
			if (result.exists() && result.canRead()) {
				dots.add(result.getAbsoluteFile());
			}
			final File result2 = new File(new File(f, "release/bin"), "dot.exe");
			if (result2.exists() && result2.canRead()) {
				dots.add(result2.getAbsoluteFile());
			}
		}
		return higherVersion(dots);
	}

	static File higherVersion(List<File> dots) {
		if (dots.size() == 0) {
			return null;
		}
		Collections.sort(dots, Collections.reverseOrder());
		return dots.get(0);
	}

	GraphvizWindowsOld(ISkinParam skinParam, String dotString, String... type) {
		super(skinParam, dotString, type);
	}

	@Override
	protected String getExeName() {
		return "dot.exe";
	}

}
