// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.ditaa;

import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;

public class PSystemDitaaFactory extends PSystemBasicFactory<PSystemDitaa> {
    // ::remove folder when __HAXE__

	// private StringBuilder data;
	// // -E,--no-separation
	// private boolean performSeparationOfCommonEdges;
	//
	// // -S,--no-shadows
	// private boolean dropShadows;

	public PSystemDitaaFactory() {
		super(DiagramType.DITAA);
	}

	@Override
	public PSystemDitaa initDiagram(UmlSource source, String startLine) {
		boolean performSeparationOfCommonEdges = true;
		if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation")))
			performSeparationOfCommonEdges = false;

		boolean dropShadows = true;
		if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows")))
			dropShadows = false;

		boolean allCornersAreRound = false;
		if (startLine != null && (startLine.contains("-r") || startLine.contains("--round-corners")))
			allCornersAreRound = true;

		boolean transparentBackground = false;
		if (startLine != null && (startLine.contains("-T") || startLine.contains("--transparent")))
			transparentBackground = true;

		boolean forceFontSize = false;
		if (startLine != null && startLine.contains("--font-size"))
			forceFontSize = true;

		final float scale = extractScale(startLine);
		final Font font = extractFont(startLine);

		return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound,
				transparentBackground, scale, font, forceFontSize);

	}

	@Override
	public PSystemDitaa executeLine(UmlSource source, PSystemDitaa system, String line) {
		if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
			boolean performSeparationOfCommonEdges = true;
			if (line.contains("-E") || line.contains("--no-separation"))
				performSeparationOfCommonEdges = false;

			boolean dropShadows = true;
			if (line.contains("-S") || line.contains("--no-shadows"))
				dropShadows = false;

			boolean allCornersAreRound = false;
			if (line.contains("-r") || line.contains("--round-corners"))
				allCornersAreRound = true;

			boolean transparentBackground = false;
			if (line.contains("-T") || line.contains("--transparent"))
				transparentBackground = true;

			boolean forceFontSize = false;
			if (line.contains("--font-size"))
				forceFontSize = true;

			final float scale = extractScale(line);
			final Font font = extractFont(line);
			return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound,
					transparentBackground, scale, font, forceFontSize);
		}
		if (system == null)
			return null;

		return system.add(line);
	}

	private float extractScale(String line) {
		if (line == null)
			return 1;

		final Pattern p = Pattern.compile("scale=([\\d.]+)");
		final Matcher m = p.matcher(line);
		if (m.find()) {
			final String number = m.group(1);
			return Float.parseFloat(number);
		}
		return 1;
	}

	private Font extractFont(String line) {
		if (line == null)
			return new Font("Dialog", Font.BOLD, 12);

		final Pattern pName = Pattern.compile("font-family=([a-zA-Z0-0 ]+)");
		final Matcher mName = pName.matcher(line);
		String fontName = "Dialog";
		if (mName.find()) {
			fontName = mName.group(1);
		}

		final Pattern pVariant = Pattern.compile("font-variant=(BOLD|ITALIC|PLAIN)");
		final Matcher mVariant = pVariant.matcher(line);
		int fontVariant = Font.BOLD;
		if (mVariant.find()) {
			switch (mVariant.group(1)) {
			case "BOLD":
				fontVariant = Font.BOLD;
				break;
			case "ITALIC":
				fontVariant = Font.ITALIC;
				break;
			case "PLAIN":
				fontVariant = Font.PLAIN;
				break;
			}
		}

		final Pattern pSize = Pattern.compile("font-size=([\\d]+)");
		final Matcher mSize = pSize.matcher(line);
		int fontSize = 12;
		if (mSize.find()) {
			fontSize = Integer.parseInt(mSize.group(1));
		}

		return new Font(fontName, fontVariant, fontSize);
	}
}
