// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.dedication;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RBlocks {

	private final List<RBlock> all = new ArrayList<>();

	private RBlocks() {

	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append(all.size());
		for (RBlock block : all) {
			sb.append(" - ");
			sb.append(block.toString());
		}
		return sb.toString();
	}

	public static RBlocks readFrom(byte[] fileContent, int size) {
		final RBlocks result = new RBlocks();
		int start = 0;
		while (start < fileContent.length) {
			final RBlock block = new RBlock(fileContent, start, size);
			start += size;
			result.all.add(block);
		}
		return result;
	}

	public RBlocks change(BigInteger E, BigInteger N) {
		final RBlocks result = new RBlocks();
		for (RBlock rsa : all)
			result.all.add(rsa.change(E, N));

		return result;
	}

	public void writeTo(Path out, int size) throws IOException {
		writeTo(new FileOutputStream(out.toFile()), size);
	}

	public byte[] toByteArray(int size) throws IOException {
		final byte[] result = new byte[size * all.size()];
		for (int i = 0; i < all.size(); i++) {
			final byte[] tmp = all.get(i).getData(size);
			System.arraycopy(tmp, 0, result, i * size, tmp.length);
		}
		return result;
	}

	public void writeTo(OutputStream os, int size) throws IOException {
		for (RBlock rsa : all) {
			final byte[] tmp = rsa.getData(size);
			os.write(tmp);
		}
		os.close();
	}

}
