// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.dedication;

import java.math.BigInteger;

public class RBlock {

	private final byte[] buffer;

	private RBlock(final byte[] init) {
		this.buffer = new byte[init.length + 1];
		System.arraycopy(init, 0, buffer, 1, init.length);
	}

	public RBlock(final byte[] init, int start, int size) {
		this.buffer = new byte[size + 1];
		if (start + size < init.length)
			System.arraycopy(init, start, buffer, 1, size);
		else
			System.arraycopy(init, start, buffer, 1, init.length - start);
	}

	public RBlock change(BigInteger E, BigInteger N) {
		final BigInteger big = new BigInteger(buffer);
		final BigInteger changed = big.modPow(E, N);
		return new RBlock(changed.toByteArray());
	}

	public byte[] getData(int size) {
		if (buffer.length == size)
			return buffer;

		final byte[] result = new byte[size];
		System.arraycopy(buffer, buffer.length - size, result, 0, size);
		return result;
	}

}
