// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.dedication;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.MTRandom;

public class DedicationCrypted implements Dedication {

	private final String argon2;
	private final BigInteger pq;
	private final byte crypted[];
	private final int tinyHash;
	private String solution;

	private long next = 0L;

	public DedicationCrypted(byte crypted[], int tinyHash, String argon2, BigInteger pq) {
		this.crypted = crypted;
		this.pq = pq;
		this.argon2 = argon2;
		this.tinyHash = tinyHash;
	}

	public synchronized BufferedImage getImage(final TinyHashableString sentence) {
		final String line = sentence.getSentence();

		if (line.length() < 40)
			return null;

		try {
			if (solution == null || line.equals(this.solution) == false) {
				if (System.currentTimeMillis() < next)
					return null;

				if (this.tinyHash != sentence.tinyHash())
					return null;

				this.next = System.currentTimeMillis() + 5000L;
			}

			final byte[] hash1 = Noise.computeArgon2bytes(line.getBytes(UTF_8),
					(pq.toString(35) + line).getBytes(UTF_8));
			final byte[] hash2 = Noise.computeArgon2bytes(line.getBytes(UTF_8),
					(pq.toString(36) + line).getBytes(UTF_8));

			final BlumBlumShub rndBBS = new BlumBlumShub(pq, hash1);
			final MTRandom rndMT = new MTRandom(hash2);

			byte[] current = crypted.clone();
			Noise.shuffle(current, rndMT);
			Noise.xor(current, rndBBS);
			Noise.xor(current, line.getBytes(UTF_8));

			Noise.shuffle(current, rndMT);

			final RBlocks init = RBlocks.readFrom(current, 513);
			final RBlocks decoded = init.change(E, N);

			current = decoded.toByteArray(512);

			Noise.shuffle(current, rndMT);
			Noise.xor(current, rndBBS);

			final String argon = Noise.computeArgon2String(current, (pq.toString(34) + line).getBytes(UTF_8));

			if (this.argon2.equals(argon) == false)
				return null;

			Noise.shuffle(current, rndMT);
			current = Noise.reverse(current, rndMT.nextInt());

			final BufferedImage img = SFile.getBufferedImageFromWebpButHeader(new ByteArrayInputStream(current));
			this.solution = line;
			return img;
		} catch (Throwable t) {
			Logme.error(t);
			return null;
		}

	}

}
