// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.board;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class BNode {
    // ::remove folder when __HAXE__

	private final String name;
	private final int stage;
	private int x = -1;
	private BNode parent;
	private final List<BNode> children = new ArrayList<>();

	public BNode(int stage, String name) {
		this.name = name;
		this.stage = stage;
	}

	public void addChild(BNode child) {
		if (child.stage <= this.stage) {
			throw new IllegalArgumentException();
		}
		this.children.add(child);
		if (child.parent != null) {
			throw new IllegalArgumentException();
		}
		child.parent = this;
	}

	public final String getName() {
		return name;
	}

	public final int getStage() {
		return stage;
	}

	public final BNode getParent() {
		return parent;
	}

	@Override
	public String toString() {
		return name + "(" + stage + ") [" + x + "]";
	}

	public void computeX(AtomicInteger count) {
		this.x = count.intValue();
		for (int i = 0; i < children.size(); i++) {
			final BNode child = children.get(i);
			if (i > 0) {
				count.addAndGet(1);
			}
			child.computeX(count);
		}
	}

	public void initBarray(BArray array) {
		array.put(this);
		for (BNode child : children) {
			child.initBarray(array);
		}

	}

	public final int getX() {
		return x;
	}

}
