// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class GPoint {

	public static final String NORTH_HOOK = "NORTH_HOOK";
	public static final String SOUTH_HOOK = "SOUTH_HOOK";
	public static final String WEST_HOOK = "WEST_HOOK";
	public static final String EAST_HOOK = "EAST_HOOK";

	public static final String NORTH_BORDER = "NORTH_BORDER";
	public static final String SOUTH_BORDER = "SOUTH_BORDER";
	public static final String WEST_BORDER = "WEST_BORDER";
	public static final String EAST_BORDER = "EAST_BORDER";

	private final Gtile gtile;
	private final String name;
	private final LinkRendering linkRendering;

	public GPoint(Gtile gtile, String name, LinkRendering linkRendering) {
		if (gtile instanceof GtileEmpty) {
			System.err.println("Warning 1");
		}

		this.gtile = gtile;
		this.name = name;
		this.linkRendering = linkRendering;
	}

	public GPoint(Gtile gtile, String name) {
		this(gtile, name, LinkRendering.none());
	}

	@Override
	public String toString() {
		return gtile + "@" + name;
	}

	public Gtile getGtile() {
		return gtile;
	}

	public String getName() {
		return name;
	}

	public UTranslate getCoord() {
		return gtile.getCoord(name);
	}

	public XPoint2D getPoint2D() {
		return getCoord().getPosition();
	}

	public LinkRendering getLinkRendering() {
		return linkRendering;
	}

	public boolean match(Swimlane swimlane) {
		final Swimlane tmp = gtile.getSwimlane(name);
		return tmp == swimlane;
	}

	public Swimlane getSwimlane() {
		final Swimlane result = gtile.getSwimlane(name);
		if (result == null) {
			throw new IllegalStateException(name + " " + gtile.getClass().toString() + " " + gtile);
		}
		return result;
	}

}
