// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.style.ISkinParam;

public abstract class AbstractGtileRoot extends AbstractTextBlock implements Gtile {

	protected final StringBounder stringBounder;
	private final ISkinParam skinParam;

	public AbstractGtileRoot(StringBounder stringBounder, ISkinParam skinParam) {
		this.stringBounder = stringBounder;
		this.skinParam = skinParam;
	}

	@Override
	final public StringBounder getStringBounder() {
		return stringBounder;
	}

	final public ISkinParam skinParam() {
		if (skinParam == null) {
			throw new IllegalStateException();
		}
		return skinParam;
	}

	final public HColorSet getIHtmlColorSet() {
		return skinParam.getIHtmlColorSet();
	}

	@Override
	final public GPoint getGPoint(String name) {
		if (name.equals(GPoint.NORTH_HOOK) || name.equals(GPoint.SOUTH_HOOK) || name.equals(GPoint.WEST_HOOK)
				|| name.equals(GPoint.EAST_HOOK) || name.equals(GPoint.NORTH_BORDER) || name.equals(GPoint.SOUTH_BORDER)
				|| name.equals(GPoint.WEST_BORDER) || name.equals(GPoint.EAST_BORDER))
			return new GPoint(this, name);
		throw new UnsupportedOperationException();
	}

	@Override
	public final UTranslate getCoord(String name) {
		if (name.equals(GPoint.NORTH_BORDER)) {
			final UTranslate tmp = getCoordImpl(GPoint.NORTH_HOOK);
			return new UTranslate(tmp.getDx(), 0);
		}
		if (name.equals(GPoint.SOUTH_BORDER)) {
			final UTranslate tmp = getCoordImpl(GPoint.SOUTH_HOOK);
			return new UTranslate(tmp.getDx(), calculateDimension(stringBounder).getHeight());
		}
		if (name.equals(GPoint.WEST_BORDER)) {
			final UTranslate tmp = getCoordImpl(GPoint.WEST_HOOK);
			return new UTranslate(0, tmp.getDy());
		}
		if (name.equals(GPoint.EAST_BORDER)) {
			final UTranslate tmp = getCoordImpl(GPoint.EAST_HOOK);
			return new UTranslate(calculateDimension(stringBounder).getWidth(), tmp.getDy());
		}
		return getCoordImpl(name);
	}

	abstract protected UTranslate getCoordImpl(String name);

	@Override
	final public void drawU(UGraphic ug) {
		drawUInternal(ug);
		for (GConnection connection : getInnerConnections()) {
			ug.draw(connection);
		}

	}

	abstract protected void drawUInternal(UGraphic ug);

}
